#!/bin/bash

#Validation to execute the script as 'root' user
  if [ `id -u` -ne 0 ]
  then
    echo "This script can be executed only as 'root' use. Exiting..."
    exit 1
  fi

#Function to set up SSH key based authentication

  copySShKey () {

    /usr/bin/expect <(cat << EOF
    spawn ssh-copy-id -i .ssh/id_rsa $1@$2
    expect {
      -re ".*es.*o.*" {
        exp_send "yes\r"
        exp_continue
      }
      -re ".*sword.*" {
        exp_send "$3\r"
      }
    }
expect eof
EOF
)
    if [ $? -eq 0 ]
    then
      echo "Successfully copied the public key to $2"
    else
      echo "Failed to copy the public key to $2. Exiting..."
      exit 1
    fi
  
  }

  setUpSSH () {
    if [ ! -f $PWD/.ssh/id_rsa  ] && [ ! -f $PWD/.ssh/id_rsa.pub ]
    then
      rm -rf $PWD/.ssh
      mkdir $PWD/.ssh
      if [ $? -eq 0 ]
      then
        echo "Successfully created $PWD/.ssh directory"
      else
        echo "Failed to create directory $PWD/.ssh. Make sure 'root' user has required permission to create $PWD/.ssh directory. Exiting..."
        exit 1
      fi

      ssh-keygen -t rsa -b 2048 -q -N "" -f $PWD/.ssh/id_rsa
      if [ $? -eq 0 ]
      then
        echo "Successfully generated SSH keys at $PWD/.ssh directory"
      else
        echo "Failed to generate SSH keys at $PWD/.ssh directory. Exiting..."
        exit 1
      fi
      copySShKey "$1" "$2" "$3"  
    else
      echo "SSH keys already exists at $PWD/.ssh directory"
      if ssh -o IdentitiesOnly=yes -o BatchMode=yes -i $PWD/.ssh/id_rsa -q $1@$2 exit
      then
        echo "SSH connection already exists to $2"
      else
        copySShKey "$1" "$2" "$3"
      fi
    fi

  }


  echo "*****************************************************"
  echo "1. Create schedule to copy latest Backup Report"
  echo "2. Delete schedule that copies latest Backup Report"
  echo "3. Exit"
  echo "*****************************************************"
  echo
  echo "Option [1 | 2 | 3]:"
  read option

  CRON_ALLOW="/etc/cron.allow"
  CRON_FILE="/var/spool/cron/root"

  if [ $option == "1" ]
  then
    echo
    echo "Enter database name whose latest backup report must be copied: "
    read dbname

    CRONJOBPRESENT=$(crontab -l | grep -iw "$PWD/backup.sh $dbname")
    if [  ! -z "$CRONJOBPRESENT" ]
    then
      echo "Scheudule to copy latest backup report is already present for $dbname database. Existing schedule must be deleted using option 2 to schedule new one. Exiting..."
      exit 1
    fi

    /opt/oracle/dcs/bin/odacli list-backupreports | grep -iw $dbname > ${dbname}_backupreports.txt
    if [ ! -s ${dbname}_backupreports.txt ]
    then
      echo "No backup reports found for the $dbname database. Exiting..."
      rm -f ${dbname}_backupreports.txt
      exit 1
    fi

    echo
    echo "Enter IP address of target machine where latest backup report must be copied: "
    read targetip

    echo
    echo "Enter OS user name of $targetip, as whom the connection should be made to copy the latest backup report: "
    read username

    echo
    echo "Enter password of '$username' user of $targetip machine: "
    read -s password

    echo
    echo "Enter backup location of $targetip machine where the latest backup report must be copied: "
    read bkploc
    echo


    rm -f ${dbname}_backupreports.txt
    ID=$(/opt/oracle/dcs/bin/odacli list-databases | grep -iw $dbname | awk '{print $1}')
    if [ -z "$ID" ]
    then
      echo "$dbname database is not present. Only latest backup report will be copied without creating the schedule"
      setUpSSH "$username" "$targetip" "$password"
      echo "Copying latest backup report to ${targetip}:${bkploc} by connecting as ${username} user"
      /bin/bash backup.sh $dbname $PWD $targetip $username $bkploc >> $PWD/backup.log
    else
      setUpSSH "$username" "$targetip" "$password"
      if [ ! -f $CRON_ALLOW ]
      then
        echo " $CRON_ALLOW file does not exist, Creating.."
        echo "root" > $CRON_ALLOW
      else
        echo " $CRON_ALLOW exist. Adding root user.."
        echo "root" > $CRON_ALLOW
      fi

      if [ ! -f $CRON_FILE ]
      then
        echo "$CRON_FILE file for root user does not exist, Creating.."
        touch $CRON_FILE
        /usr/bin/crontab $CRON_FILE
      else
        /usr/bin/crontab $CRON_FILE
      fi
      echo "*/30 * * * * /bin/bash $PWD/backup.sh $dbname $PWD $targetip $username $bkploc >> $PWD/backup.log 2>&1" >> $CRON_FILE
      if [ $? -eq 0 ]
      then
        echo "Successfully created cron job to copy latest backupreport of $dbname database"
      else
        echo "Failed to create cron job to copy latest backupreport of $dbname database"
      fi
    fi
  elif [ $option == "2" ]
  then
    echo
    echo "Enter database name whose schedule that copies the latest backup report must be deleted: "
    read dbname

    RESULT=$(crontab -l | grep -iw "$PWD/backup.sh $dbname")
    if [  ! -z "$RESULT" ]
    then
      sed -i "/$dbname\b/Id"  $CRON_FILE
      if [ $? -eq 0 ]
      then
        echo "Successfully deleted schedule that copies latest backup report of $dbname database"
      else
        echo "Failed to delete schedule that copies latest backup report of $dbname database"
      fi
    else
      echo "No schedule found for $dbname database. Exiting..."
      exit 1
    fi
  else
    echo " Exiting.."
    exit 1
  fi
