#!/bin/bash

#Remove existing backup report locally as well as at target location, if present
rm -f $2/$1_backupreport.json
ssh -i $2/.ssh/id_rsa $4@$3 "rm -f $5/$1_backupreport.json"

/opt/oracle/dcs/bin/odacli list-backupreports | grep -iw $1  > $2/$1_backupreports.txt
if [ $? -eq 0 ]
then
   echo $(date -u) "$1 : Successfully listed all the backupreports of $1 database"
else
   echo $(date -u) "$1 : No backupreports found for $1 database. Exiting..."i
   rm -f $2/$1_backupreports.txt
   exit 1
fi

while read -r line;
do
  BKPRPT=(${line})
  STRINGDATE="${BKPRPT[13]} ${BKPRPT[14]} ${BKPRPT[15]} ${BKPRPT[16]} ${BKPRPT[17]} ${BKPRPT[18]}"
  FORMATEDDATE=$(date -d "$STRINGDATE" +"%Y-%m-%d %H:%M:%S")
  sed -i "s/$STRINGDATE/$FORMATEDDATE/g" $2/$1_backupreports.txt
  if [ $? -ne 0 ]
  then
    echo $(date -u) "$1 : Failed to changed the date format of backupreport. Exiting..."
    rm -f $2/$1_backupreports.txt
    exit 1
  fi
done < $2/$1_backupreports.txt

awk '{print $1,$2, $3, $4, $5, $6, $8, $9, $10, $11, $12, $13, $14, $15, $16}' $2/$1_backupreports.txt > $2/$1_backupreports_tmp.txt
sort -o $2/$1_backupreports_tmp.txt -k7.1 -k7.6 -k7.9 -k8 $2/$1_backupreports_tmp.txt
if [ $? -eq 0 ]
then
   echo $(date -u) "$1 : Successfully sorted all backupreports of $1 database"
else
   echo $(date -u) "$1 : Failed to sort all backupreports of $1 database. Exiting..."
   rm -f $2/$1_backupreports_tmp.txt $2/$1_backupreports.txt
   exit 1
fi

LATEST_BKPRPT_ID=$(awk 'END{print $1}' $2/$1_backupreports_tmp.txt)
rm -f $2/$1_backupreports_tmp.txt $2/$1_backupreports.txt


if [ -n "$LATEST_BKPRPT_ID" ]
then
  echo $(date -u) "$1 : Found latest backupreport for $1 database"
  /opt/oracle/dcs/bin/odacli describe-backupreport -i $LATEST_BKPRPT_ID > $2/$1_backupreport.json
  if [ $? -eq 0 ]
  then
    echo $(date -u) "$1 : Successfully created the backupreport JSON locally with ID $ID"
  else
    echo $(date -u) "$1 : Failed to create the backupreport JSON locally with ID $ID. Exiting..."
    exit 1
  fi

  scp -i $2/.ssh/id_rsa $2/$1_backupreport.json $4@$3:$5
  if [ $? -eq 0 ]
  then
    echo $(date -u) "$1 : Successfully copied the backupreport to $3:$5"
  else
    echo $(date -u) "$1 : Failed to copy the backupreport to $3:$5"
  fi
  
  rm $2/$1_backupreport.json
  if [ $? -eq 0 ]
  then
    echo $(date -u) "$1 : Successfully removed backupreport that was created locally."
  else
    echo $(date -u) "$1 : Failed to remove backupreport that was created locally."
  fi
  
else
  echo $(date -u) "$1 : Latest backupreport not found for $1 database."
fi
