locals { 

# Find the domain endpoint that is associated with the current user (not null)
current_domain_endpoint = flatten([for each in data.oci_identity_domains_user.possible_domains[*].idcs_endpoint : each if each != tostring(null)])

# Determine the URLs of possible domains
possible_urls = flatten(data.oci_identity_domains.all_domains[*].domains[*].url)


# Used to determine if the identity domain needs to be replicated
identity_domain_replications = var.REGION == data.oci_identity_regions.home_region.regions[0]["name"] ? 0 : 1

# Based on the prepare_variables_upload.tf file contents
parent_compartment_id = var.parent_compartment_id == "null" ? data.oci_identity_tenancy.tenancy.id : var.parent_compartment_id

policy_group = join ("", [var.FA_Domain_Name, "/Domain_Administrators"] )
policy_statements  = join (" ", ["Allow Group", local.policy_group, "to MANAGE All-Resources in Compartment", var.FA_Compartment_Name] )

FA_Domain_Console_URL0 = join ("", [var.FA_Domain_Name, "%20&region"] )
FA_Domain_Console_URL1 = join ("", [data.oci_identity_tenancy.tenancy.name,"&domain"] )

FA_Domain_User_Login = "To provision the Fusion Analytics instance, sign in to OCI using this link: "
FA_Domain_User_Login_URL = join ("=", ["https://cloud.oracle.com/identity/domains/?tenant", local.FA_Domain_Console_URL1, local.FA_Domain_Console_URL0, var.REGION] )
FA_Domain_User_Name = join ("", ["Using User: ", oci_identity_domain.fa_domain.admin_user_name] )

}

