


resource "oci_identity_compartment" "fa_compartment" {
    # Required
    compartment_id = local.parent_compartment_id
    # Have script add a line to added_variables
    provider       = oci.home
    enable_delete = "true"
    description = "Example Compartment for Fusion Analytics Service Endpoints"
    name = var.FA_Compartment_Name
}

resource "oci_identity_domain" "fa_domain" {
    #Required
    provider       = oci.home
    compartment_id = oci_identity_compartment.fa_compartment.id
    description = "FA Example Identity Domain"
    display_name = var.FA_Domain_Name
    home_region = data.oci_identity_regions.home_region.regions[0]["name"]
    license_type = "free"

    #Optional
    state = "ACTIVE"
    admin_email = data.oci_identity_domains_user.current_user.emails[0].value
    admin_first_name = "Example"
    admin_last_name = "ServiceAdmin"
    admin_user_name = "Example.ServiceAdmin"
    is_hidden_on_login = "true"
    is_notification_bypassed = "false"
    is_primary_email_required = "false"
}

resource "oci_identity_domain_replication_to_region" "my_region" {
    #Required
    domain_id = oci_identity_domain.fa_domain.id
    provider = oci.home
    # Only create if the FA region is different than the home region
    count = local.identity_domain_replications

    #Optional
    replica_region = var.REGION
}

resource "oci_identity_policy" "fa_compartment_policy" {
    #Required
    compartment_id = var.parent_compartment_id
    description = "Policy for the FA_Compartment"
    name = var.FA_Compartment_Policy_Name
    statements =[local.policy_statements] 
}


