
# Determine active, accessible compartment that the current user's identity domain may be in
data "oci_identity_compartments" "all_compartments" {
    #Required
    #provider = oci.home
    compartment_id = var.TENANCY

    #Optional
    access_level = "ACCESSIBLE"
    compartment_id_in_subtree = "true"
    state = "ACTIVE"
}

# Determine the possible domains using the list of possible compartments.
data "oci_identity_domains" "all_domains" {
     #provider = oci.home
     count = length(data.oci_identity_compartments.all_compartments.compartments)
     compartment_id = data.oci_identity_compartments.all_compartments.compartments[count.index].id
}

data "oci_identity_tenancy" "tenancy" {
  #provider = oci.home
  tenancy_id = var.TENANCY
}


data "oci_identity_regions" "home_region" { 
  #provider = oci.home
  filter {
    name   = "key"
    values = [data.oci_identity_tenancy.tenancy.home_region_key]
  }
}

