## This configuration was generated by terraform-provider-oci

resource oci_core_network_security_group fa_adw_nsg {
  compartment_id = oci_identity_compartment.fa_compartment.id
  display_name = var.FA_ADW_NSG_Name
  vcn_id = oci_core_vcn.fa_vcn.id
}

resource oci_core_subnet fa_private_sn {
  compartment_id = oci_identity_compartment.fa_compartment.id
  vcn_id = oci_core_vcn.fa_vcn.id
  cidr_block     = "10.50.0.0/26"
  display_name    = var.FA_Private_SN_Name
  dns_label       = "favcnprvsn"
  prohibit_internet_ingress  = "true"
  prohibit_public_ip_on_vnic = "true"
  route_table_id             = oci_core_vcn.fa_vcn.default_route_table_id
  security_list_ids = [
    oci_core_security_list.fa_private_sn_sl.id,
  ]
}

resource oci_core_vcn fa_vcn {
  cidr_blocks = [
    "10.50.0.0/16",
  ]
  compartment_id = oci_identity_compartment.fa_compartment.id
  display_name = var.FA_VCN_Name
  dns_label    = "favcn"
}

resource oci_core_security_list fa_private_sn_sl {
  compartment_id = oci_identity_compartment.fa_compartment.id
  vcn_id = oci_core_vcn.fa_vcn.id
  display_name = var.FA_Private_SN_SL_Name
  egress_security_rules {
    destination      = "0.0.0.0/0"
    destination_type = "CIDR_BLOCK"
    protocol  = "all"
    stateless = "false"
  }

  ingress_security_rules {
    description = "This Private SN"
    protocol    = "6"
    source      = "10.50.0.0/26"
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "443"
      min = "443"
    }
  }

  ingress_security_rules {
    description = "This Private SN"
    protocol    = "6"
    source      = "10.50.0.0/26"
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "1522"
      min = "1522"
    }
  }
}

