#!/bin/bash

host=oasdev.oracleceal.com

# Steps below will configure apache for ssl by creating a self signed server certificate and its private key
# Deleting existing certificates and keys
rm -f ./server.crt
rm -f ./server.key
rm -f ./server.csr
# Generating new server key
openssl genrsa -aes256 -passout pass:Oracle123 -out ./server1.key 2048
# Removing the PassPhrase from server1.key
openssl rsa -passin pass:Oracle123 -in ./server1.key -out ./server.key
# deleting the backup of the key
rm ./server1.key
# Generating server certificate sign request i.e server.csr
openssl req -subj "/C=US/ST=California/L=RedwoodShores/O=Oracle Corporation/OU=Oracle Analytics Server/CN=$host" -out ./server.csr -key ./server.key -new -sha256
# Signing the CSR and generating a self signed certificate
# If you are signing the CSR with external CA then import the CA Cert or CA Bundle into conf folder and set the appropriate cert locations in conf.d/ssl.conf
# Also import the server.crt after the CSR is signed by the external CA
openssl x509 -req -days 365 -sha256 -in ./server.csr -signkey ./server.key -out ./server.crt


