#!/bin/bash

#--------------------------------------------------------------
# Enter Parameter Values
#--------------------------------------------------------------
OS_User=oracle
OAS_ORACLE_HOME=/u01/app/Oracle/Middleware/Oracle_Home
OAS_DOMAIN_HOME=/u01/data/domains/bi
adminUsername=admin
adminPassword=Welc0me1
adminURL=t3://10.0.0.190:9500
SSLLogOffURL=/logout.html
#--------------------------------------------------------------


prequisiteCheck()
{
 # Check if the user is root
 if [ "$(whoami)" != "$OS_User" ]; then
    echo "This script must be run as $OS_User"
    exit 1
 fi
}


setSSOLogOffURL()
{
 # Check the Current Logoff URL.
 echo "Checking the current LogOff URL....."
 LogoffURL=$(grep -oP '<bi:logoff-url>\K[^<]+' $OAS_DOMAIN_HOME/config/fmwconfig/bienv/core/bi-environment.xml)
 echo "Current LogOff URL: $LogoffURL"
 
 echo "readDomain('$OAS_DOMAIN_HOME')
enableBISingleSignOn('$OAS_DOMAIN_HOME','$SSLLogOffURL')
updateDomain()
closeDomain()
exit()" > ssologoffURL.py

 $OAS_ORACLE_HOME/oracle_common/common/bin/wlst.sh ssologoffURL.py
 rm -f ssologoffURL.py
 
 # Check the New Logoff URL.
 echo "Checking the new LogOff URL....."
 LogoffURL2=$(grep -oP '<bi:logoff-url>\K[^<]+' $OAS_DOMAIN_HOME/config/fmwconfig/bienv/core/bi-environment.xml)
 echo "New LogOff URL: $LogoffURL2"
 
 # Check if the SSLLogOffURL is set correctly.
 if [[ $LogoffURL2 == $SSLLogOffURL ]]; then
	echo "Successfully updated the SSO Logoff URL....."
 else
	echo "Unable to update the SSO Logoff URL......"
	exit 1
 fi
}


enableWebLogicPlugin()
{
 echo "Checking if the WebLogic Plugin is enabled....."
 # Check if the WebLogic Plugin enabled or not at the Domain Level.
 WPenabled=$(grep -oP '<weblogic-plugin-enabled>\K[^<]+' $OAS_DOMAIN_HOME/config/config.xml)
 if [[ $WPenabled == false ]]; then
	echo "WebLogic Plugin is not enabled at the domain level, enabling it....."
	
	echo "connect('$adminUsername','$adminPassword','$adminURL')
edit()
startEdit()
cd('/WebAppContainer/bi')
cmo.setWeblogicPluginEnabled(true)
save()
activate()
disconnect()
exit()" > wlplugin.py

	$OAS_ORACLE_HOME/oracle_common/common/bin/wlst.sh wlplugin.py
	rm -f wlplugin.py
	
	echo "Checking....."
	WPenable=$(grep -oP '<weblogic-plugin-enabled>\K[^<]+' $OAS_DOMAIN_HOME/config/config.xml)
	if [[ $WPenable == true ]]; then
		echo "WebLogic Plugin is enabled successfully at the domain level."
	fi	
 else
	echo "WebLogic Plugin is already enabled at the domain level."
 fi
}


createOAMAsserter()
{
 echo "Creating OAMIdentityAsserter....."
 echo "connect('$adminUsername','$adminPassword','$adminURL')
edit()
startEdit()
cd('/SecurityConfiguration/bi/Realms/myrealm')
cmo.createAuthenticationProvider('OAMIdentityAsserter', 'oracle.security.wls.oam.providers.asserter.OAMIdentityAsserter')
 
cd('/SecurityConfiguration/bi/Realms/myrealm/AuthenticationProviders/OAMIdentityAsserter')
cmo.setControlFlag('OPTIONAL')
cmo.setControlFlag('REQUIRED')

cd('/SecurityConfiguration/bi/Realms/myrealm/AuthenticationProviders/DefaultAuthenticator')
cmo.setControlFlag('SUFFICIENT')

save()
activate()
disconnect()
exit()" > oamasserter.py
 
 $OAS_ORACLE_HOME/oracle_common/common/bin/wlst.sh oamasserter.py
 rm -f oamasserter.py
}


getAuthenticationProviders()
{
 echo "Get the list of authentication providers....."
 
 echo "connect('$adminUsername','$adminPassword','$adminURL')
cd('/SecurityConfiguration/bi/Realms/myrealm')
cd('AuthenticationProviders')
ls()" > listproviders.py
 
 $OAS_ORACLE_HOME/oracle_common/common/bin/wlst.sh listproviders.py > authproviders.txt
 rm -f listproviders.py
}

formatListintoArray()
{
 # Validate the authproviders.txt file 
 grep '^dr--' authproviders.txt | sed 's/^dr-- *//' > listproviders.txt
 rm -f authproviders.txt
 # Read the contents of listproviders.txt into an array
 mapfile -t items < listproviders.txt

 # Reorder the array elements based on the requirements
 first="OAMIdentityAsserter"
 last="DefaultIdentityAsserter"
 last_but_one="DefaultAuthenticator"
 last_but_two="Trust Service Identity Asserter"

 # Find the index of each element in the array
 first_index=$(printf "%s\n" "${items[@]}" | grep -n "$first" | cut -d: -f1)
 last_index=$(printf "%s\n" "${items[@]}" | grep -n "$last" | cut -d: -f1)
 last_but_one_index=$(printf "%s\n" "${items[@]}" | grep -n "$last_but_one" | cut -d: -f1)
 last_but_two_index=$(printf "%s\n" "${items[@]}" | grep -n "$last_but_two" | cut -d: -f1)

 # Remove the elements from the array
 unset 'items[first_index-1]'
 unset 'items[last_but_two_index-1]'
 unset 'items[last_but_one_index-1]'
 unset 'items[last_index-1]'

 # Add the elements back to the array in the required order
 reordered_items=("$first" "${items[@]}" "$last_but_two" "$last_but_one" "$last")

 # Format the array elements
 formatted_items=()
 for item in "${reordered_items[@]}"; do
     formatted_items+=( "ObjectName('Security:Name=myrealm$item')" )
 done

 # Join array elements with comma and space
 IFS=', '
 formatted_array="[${formatted_items[*]}]"

 echo "$formatted_array"

 
 # Use sed to add a space after each comma
 formatted_array_with_space=$(echo "$formatted_array" | sed 's/,/, /g')
 echo "$formatted_array_with_space"
 
 rm -f listproviders.txt
}

 
reorderProviders()
{
 echo "Re ordering the authentication providers....."
 echo "connect('$adminUsername','$adminPassword','$adminURL')
edit()
startEdit()
cd('/SecurityConfiguration/bi/Realms/myrealm')
set('AuthenticationProviders',jarray.array($formatted_array_with_space, ObjectName))
save()
activate()
disconnect()
exit()" > reorder.py

 $OAS_ORACLE_HOME/oracle_common/common/bin/wlst.sh reorder.py
 rm -f reorder.py
}


restartOAS()
{
# Stop OAS.
 $OAS_DOMAIN_HOME/bitools/bin/stop.sh
 
 # Start OAS.
 $OAS_DOMAIN_HOME/bitools/bin/start.sh
}


# call all functions.
prequisiteCheck
setSSOLogOffURL
enableWebLogicPlugin
createOAMAsserter
getAuthenticationProviders
formatListintoArray
reorderProviders
restartOAS