#!/bin/bash

#-----------------------------------------------------------------------
# Enter Parameter Values.
#-----------------------------------------------------------------------
# Add the proxy server URL if the environment needs it to connect to Internet.
http_proxy=http://www-proxy.example.com:8080
https_proxy=http://www-proxy.example.com:8080

# Place the below file in the path $PWD/shibdFiles
#-----------------------------------------------------------------------
# Get the IDP Metadata xml file and place it in the $PWD/shibdFiles folder.
# If the Metadata is from ADFS, Follow the README and Deelete the SPSSOIdentifier before using it.
IDP_MetadataFile=IDCSMetadata.xml
# Frontend like Load Balancer or Oracle HTTP Server Certificates.
ServerCertificate=oasdev.crt
ServerPrivateKey=oasdev.key
# Skip provinding the password if your PrivateKey doesn't have a password.
PrivateKey_Password=
#-----------------------------------------------------------------------
# Enter Load Balancer or OHS (Whichever is the FrontEnd) DNS Name e.g oasdev.oracleceal.com
LoadBalancerDNS=oasdev.oracleceal.com
# Signing true|false
Signing=false
# Encryption true|false
Encryption=false
# Is the Shibboleth-SP with OHS as Single Node or a Clustered Node?
Shibd_Clustered=false
# Set a cookie Name for the Shibboleth SP Cluster
cookieName=oasdev
# Email Address of the team to reach upon issues with SSO. e.g. supportsso@oracleceal.com
supportemailAddress=supportsso@oracleceal.com
# Enter the Name ID Format: unspecified | emailAddress
NameIDFormat=unspecified
# Specify the Operating System release like 7 or 8 for OEL/RHEL.
OS_Release=8
#-----------------------------------------------------------------------


prequisiteCheck()
{
 # Check if the user is root
 if [ "$(whoami)" != "root" ]; then
    echo "This script must be run as root"
    exit 1
 fi
 
 if [ -n "$PrivateKey_Password" ]; then
	# If the Private Key has a Password, Remove it using the below command.
	openssl rsa -in $ServerPrivateKey -out TempPrivateKey.key -passin pass:$PrivateKey_Password
	rm -f $ServerPrivateKey
	mv TempPrivateKey.key $LB_PrivateKey
 fi
 ///raghav
}


setProxy()
{
 echo "Setting the Proxy Server Details"
 export http_proxy=$http_proxy
 export https_proxy=$https_proxy
}

 
# Install Shibboleth Service Provider.
installShibd()
{
 echo "Creating the shibboleth.repo file."
 
 if [[ $OS_Release == 7 ]]; then
	# Shibboleth SP on Oracle Linux 7.x | RHEL 7.x
	echo '[shibboleth]
name=Shibboleth (CentOS_7)
# Please report any problems to https://shibboleth.atlassian.net/jira
type=rpm-md
mirrorlist=https://shibboleth.net/cgi-bin/mirrorlist.cgi/CentOS_7
gpgcheck=1
gpgkey=https://shibboleth.net/downloads/service-provider/RPMS/repomd.xml.key
        https://shibboleth.net/downloads/service-provider/RPMS/cantor.repomd.xml.key
enabled=1' > /etc/yum.repos.d/shibboleth.repo
 elif [[ $OS_Release == 8 ]]; then
	# Shibboleth SP on Oracle Linux 8.x | RHEL 8.x
	echo '[shibboleth]
name=Shibboleth (CentOS_8)
# Please report any problems to https://shibboleth.atlassian.net/jira
type=rpm-md
mirrorlist=https://shibboleth.net/cgi-bin/mirrorlist.cgi/CentOS_8
gpgcheck=1
gpgkey=https://shibboleth.net/downloads/service-provider/RPMS/repomd.xml.key
        https://shibboleth.net/downloads/service-provider/RPMS/cantor.repomd.xml.key
enabled=1' > /etc/yum.repos.d/shibboleth.repo
 else
	echo "Unable to determine the OS version with the given parameters, Exiting....."
 fi
 
 echo "Installing Shibboleth SP."
 yum install shibboleth.x86_64 -y
 yum install dos2unix -y
 yum clean all -y
 
 if [[ -d /etc/shibboleth ]]; then
	echo "Installed Shibboleth SP."
	# Copying files and taking backup.
	mv /etc/shibboleth/shibboleth2.xml /etc/shibboleth/shibboleth2.xml.orig
	mv /etc/shibboleth/attribute-map.xml /etc/shibboleth/attribute-map.xml.orig
	cp $PWD/shibdFiles/shibboleth2.xml.sample /etc/shibboleth/shibboleth2.xml.sample
	cp $PWD/shibdFiles/attribute-map.xml.sample /etc/shibboleth/attribute-map.xml.sample
	cp $PWD/shibdFiles/shibboleth2.xml.sample /etc/shibboleth/shibboleth2.xml
	cp $PWD/shibdFiles/attribute-map.xml.sample /etc/shibboleth/attribute-map.xml
	cp $PWD/shibdFiles/$IDP_MetadataFile /etc/shibboleth/idp_metadata.xml
	cat $PWD/shibdFiles/$ServerCertificate > /etc/shibboleth/sp-signing-cert.pem
	cat $PWD/shibdFiles/$ServerCertificate > /etc/shibboleth/sp-encrypt-cert.pem
	cat $PWD/shibdFiles/$ServerPrivateKey > /etc/shibboleth/sp-signing-key.pem
	cat $PWD/shibdFiles/$ServerPrivateKey > /etc/shibboleth/sp-encrypt-key.pem
 fi
}


# Configure Shibboleth Service Provider Files.
configShibd()
{
 sed -i "s|<apache-or-loadbalancer-hostname.com>|$LoadBalancerDNS|g" /etc/shibboleth/shibboleth2.xml
 sed -i "s|<signingTF>|$Signing|g" /etc/shibboleth/shibboleth2.xml
 sed -i "s|<encryptTF>|$Encryption|g" /etc/shibboleth/shibboleth2.xml
 if [[ $Shibd_Clustered == "true" ]]; then
	echo "Configuring Shibboleth-SP for a Clustered Environment."
	sed -i "s|cookieProps=\"https\"|cookieProps=\"https\" consistentAddress=\"false\" cookieName=\"$cookieName\"|g" /etc/shibboleth/shibboleth2.xml
 fi
 entity_id1=$(grep -oP 'entityID="\K[^"]+' /etc/shibboleth/idp_metadata.xml)
 # Replace each occurence of / with \/
 entity_id="${entity_id1//\//\\/}"
 sed -i "s|<IDP_EntityID>|$entity_id|g" /etc/shibboleth/shibboleth2.xml
 sed -i "s|root@localhost|$supportemailAddress|g" /etc/shibboleth/shibboleth2.xml
 sed -i "s|<NAMEID-FORMAT>|$NameIDFormat|g" /etc/shibboleth/attribute-map.xml
 
 shibd -tc /etc/shibboleth/shibboleth2.xml
}


startShibd()
{ 
 echo "Start and Enable shibd service."
 /bin/systemctl start shibd.service
 /bin/systemctl enable shibd.service
}


# Call all Functiona
prequisiteCheck
#setProxy
installShibd
configShibd
startShibd
