#!/bin/bash

#-------------------------------------------------------------------------
# Enter Variable Values
#-------------------------------------------------------------------------
# Specify the user:group installing OAS
User=ohs
Group=ohs
Software_Location=/tmp/softwares
Install_Base_Location=/scratch/ohs
# Example value of JDK Version : "1.8.0_411"
JDK_Version="1.8.0_411"
NodeManager_Username=weblogic
NodeManager_Password=Welc0me1#
#-------------------------------------------------------------------------


#-------------------------------------------------------------------------
# Set Environment Variables
#-------------------------------------------------------------------------
export MW_HOME=$Install_Base_Location/Oracle/Middleware/Oracle_Home
export WLST_HOME=$MW_HOME/oracle_common/common/bin
export JAVA_HOME=$Install_Base_Location/jdk$JDK_Version
export DOMAIN_NAME=ohs_domain
export DOMAIN_HOME=$MW_HOME/user_projects/domains/$DOMAIN_NAME
export NM_LISTENADDRESS=`hostname -f`
export NM_TYPE=SSL
export NM_PORT=5556
export NM_USERNAME=$NodeManager_Username
export NM_PASSWORD=$NodeManager_Password
export NM_HOME=$DOMAIN_HOME/nodemanager
export OHSINSTANCENAME=ohs1
export OHSADMINPORT=9999
export OHSHTTPPORT=7777
export OHSHTTPSPORT=4443
#-------------------------------------------------------------------------


# Check prerequisites are met.
prerequisiteCheck()
{
 echo "Checking Environment Variables....."
 
 # Check if the user is oracle
 if [ "$(whoami)" != "$User" ]; then
    echo "This script must be run as $User user"
    exit 1
 fi
 
 if [ -z "${MW_HOME}" -o -z "${WLST_HOME}" -o -z "${JAVA_HOME}" -o -z "${DOMAIN_NAME}" -o -z "${DOMAIN_HOME}" -o -z "${NM_LISTENADDRESS}" -o -z "${NM_TYPE}" -o -z "${NM_PORT}" -o -z "${NM_USERNAME}" -o -z "${NM_PASSWORD}" -o -z "${NM_HOME}" -o -z "${OHSADMINPORT}" -o -z "${OHSHTTPPORT}" -o -z "${OHSHTTPSPORT}" ]; then
	echo " Environment not set - Exit"
    exit 1
 fi
}


createDomain()
{ 
 if [[ ! -d "$DOMAIN_HOME" ]]; then
    echo ""
    echo "Domain Home doesn't exist....."
	echo "Creating the Domain for OHS....."
    echo ""  
    # In case we are facing problems with /dev/random
    export CONFIG_JVM_ARGS=-Djava.security.egd=file:/dev/./urandom:$CONFIG_JVM_ARGS
    ${WLST_HOME}/wlst.sh $Software_Location/create_ohs_domain.py
 else
    echo "Domain Home folder is already existing....."
 fi
 
 # Check if the Domain Home is created.
 if [[ -d "$DOMAIN_HOME" ]]; then
	echo "Domain created successfully for ohs....."
 else
	echo "Failed to create Domain for ohs....."
	exit 1
 fi
}


# Define the Ports needed to be opened.
openPorts()
{
 echo "Opening required OHS Ports at the Firewalld."
 
 sudo firewall-cmd --zone=public --permanent --add-port=$OHSHTTPPORT/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=$OHSHTTPSPORT/tcp
 sudo firewall-cmd --complete-reload
}


startOHS()
{
 cd $DOMAIN_HOME/bin
 rm -f nohup.out
 nohup $DOMAIN_HOME/bin/startNodeManager.sh &
 sleep 10
 if grep -F "<Secure socket listener started on port $NM_PORT, host `hostname -f`/`hostname -i`>" "nohup.out"; then
	echo "NodeManager Started....."
	echo "Starting ohs1....."
	echo $NM_PASSWORD | $DOMAIN_HOME/bin/startComponent.sh ohs1 storeUserConfig
	testOHS
 else
	echo "Failed to start NodeManager, Exiting....."
	exit 1
 fi
}


testOHS()
{
 OHSHost=`hostname -f`
 curl -Is "http://${OHSHost}:${OHSHTTPPORT}/" | head -n 1 > $Software_Location/result.txt

 if grep -q "HTTP/1.1 200 OK" $Software_Location/result.txt; then
    echo "OHS is up and running successfully!!!."
	cleanUP
 else
    echo "Unable to get the status of OHS Check manually!!!"
	echo "Exiting....."
	exit 1
 fi
}


# Clean Up Unwanted Files.
cleanUP()
{
 echo "Cleaning up the unwanted files after the configuration."
 rm -f $Software_Location/result.txt
}


# Call all Functions
prerequisiteCheck
createDomain
openPorts
startOHS

