#!/bin/bash

#-------------------------------------------------
# Enter Variable Values
#-------------------------------------------------
# Specify the non-root user:group installing OAS.
User=ohs
Group=ohs
GroupID=1005
UserID=1006
Software_Location=/tmp/softwares
#-------------------------------------------------

prequisiteCheck()
{
 # Check if the user is root
 if [ "$(whoami)" != "root" ]; then
    echo "This script must be run as root"
    exit 1
 fi
}

# Create OAS Installation User and Group.
createUserGroup()
{ 
 # Create a Group
 echo "Creating Group $Group with Group ID as $GroupID."
 groupadd -g $GroupID $Group

 # Create a User
 echo "Creating User $User with User ID as $UserID and adding the User to the Group."
 useradd -m -G $Group -d /home/$User -s /bin/bash -u $UserID $User
 
 # As the root user, edit the /etc/sudoers file and add the user $User to grant sudo access without password.
 echo "Granting the sudo access without password to the User $User."
 echo "%$User        ALL=(ALL)       NOPASSWD: ALL" >> /etc/sudoers
}

changeOwnership()
{
 # Change Ownership of the OAS Installation files folder from opc to oracle user.
 chown -R $User:$Group $Software_Location
 chmod +x $Software_Location/02_OHS_Install_Silent.sh
 chmod +x $Software_Location/03_Create_OHS_Domain.sh
 chmod +x $Software_Location/04_Shibboleth_Install_Config.sh
 chmod +x $Software_Location/05_OHS_Config_SSO.sh
}

# For Oracle Cloud Infrstructure (OCI) Compute expand the Root File System to use the available space in the Boot Volume.
expandRootFS()
{
 sudo /usr/libexec/oci-growfs -y
}

# Call all Functions
prequisiteCheck
createUserGroup
changeOwnership
#expandRootFS
