#!/bin/bash

#------------------------------------------------------------------------------------------------
# Enter Variable Values
#------------------------------------------------------------------------------------------------
# Specify the user:group installing OAS
User=oracle
Group=oinstall
Software_Location=/tmp/softwares
Install_Base_Location=/u01
#JDK_Version="1.8.0_411"
OAS_Admin_Username=admin
OAS_Admin_Password=Welc0me1#
DB_Hostname=oadb19.sub03021908391.oasvcn.oraclevcn.com
DB_Port=1521
DB_Servicename=PDB1.sub03021908391.oasvcn.oraclevcn.com
DB_Admin_Username=sys
DB_Admin_Password=Welc0mE1_#
RCU_Schema_Prefix=OAS2024
RCU_Schema_Password=Welc0mE1_#
#------------------------------------------------------------------------------------------------


# Check prerequisites are met.
prerequisiteCheck()
{
 echo "Checking Prerequisites....."
 
 # Check if the user is oracle
 if [ "$(whoami)" != "$User" ]; then
    echo "This script must be run as $User user"
    exit 1
 fi
}


# Create the OAS Configuration Response File.
createOASConfigRespone()
{
 echo "Creating Silent Configuration Response File for OAS."
 
 # NOTE: Some of the parameters are not changed like DomainName, PortRange 9500 to 9999. 
 # If needed change the below response file creation with your required values.  
 
 echo "[ENGINE]

#DO NOT CHANGE THIS.
Response File Version=1.0.0.0.0

[GENERIC]

#If false, omit the startup action at the end of the config assistant.
PERFORM_BI_STARTUP=true

#Set limit on number of Oracle Analytic Service Instances. Only used if SERVICE_INSTANCE_MODE = MULTI
SERVICE_INSTANCE_LIMIT=2

#If empty string will default to BI logout page
LOGOUT_URL=

#Select to include BIEE.   Values are true or false.
CONFIGURE_BIEE=true

#Select to include BIP (BI Publisher).   Values are true or false.
CONFIGURE_BIP=true

CONFIGURE_ESSBASE=false

#Install Exalytics In-Memory Software. If this is set to true and Exalytics hardware is NOT present an error will occur.
INSTALL_EXALYTICS_IN_MEMORY_SOFTWARE=false

#Set Single Service Instance vs Multi Service Instance Mode.
SERVICE_INSTANCE_MODE=SINGLE

#The domain to be created
DOMAIN_NAME=bi

#The directory in which the domain home directory will be created
DOMAINS_DIR=$Install_Base_Location/data/domains

#Specify the administrator username.
ADMIN_USER_NAME=$OAS_Admin_Username

#Specify the administrator password.
ADMIN_PASSWORD=$OAS_Admin_Password

#Specify the administrator confirmation password
ADMIN_CONFIRM_PASSWORD=$OAS_Admin_Password

#LOCAL, CREATE_ONLY, USE_EXISTING
DOMAIN_WORK=LOCAL

#Select the schema type. Supported types are SCHEMA_TYPE_NEW, SCHEMA_TYPE_EXISTING.  
SCHEMA_TYPE=SCHEMA_TYPE_NEW

#Select the existing database type to connect to. Supported database types are ORACLE, ORACLE_RAC, ORACLE_TNS_ALIAS, IBMDB2 and SQLSERVER.
EXISTING_DATABASE_TYPE=ORACLE

#Format: hostname:port:servicename. For Application Cluster Database: host1:port1^host2:port2@servicename 
CONNECT_STRING=$DB_Hostname:$DB_Port:$DB_Servicename

#Format: host1:port1^host2:port2
FAN_CONNECT_STRING=

#Select the new database type to connect to. Supported database types are ORACLE, ORACLE_RAC, and SQLSERVER.  For database types not supported with new schema create the schema in RCU and then use SCHEMA_TYPE_EXISTING
DATABASE_TYPE=ORACLE

#Username for account with privileges to create new schemas
NEW_DB_ADMIN_USERNAME=$DB_Admin_Username

#Password for account with privileges to create new schemas.
NEW_DB_PASSWORD=$DB_Admin_Password

#Prefix for newly created schemas
NEW_DB_SCHEMA_PREFIX=$RCU_Schema_Prefix

#Password to be used for all new schemas.
NEW_DB_SCHEMA_PASSWORD=$RCU_Schema_Password

#Password to be used for all new schemas.
NEW_DB_CONFIRM_SCHEMA_PASSWORD=$RCU_Schema_Password

#Enter the prefix used in RCU when the schemas were created.
EXISTING_DB_PREFIX=

#Enter the password for the STB schema.
EXISTING_DB_PASSWORD=<SECURE VALUE>

#The start port for the port range.  If 'STATIC' static ports file will be used instead.
PORT_RANGE_START=9500

#The end port for the port range. Ignored if PORT_RANGE_START is 'STATIC', in which case static ports are used.
PORT_RANGE_END=9999

#Location of static ports file.  Only set if PORT_RANGE_START is 'STATIC'
STATIC_PORTS_FILE=

#Select type of initial application.  Supported types are APPLICATION_TYPE_BI_BUNDLE, APPLICATION_TYPE_EMPTY.
APPLICATION_TYPE=APPLICATION_TYPE_EMPTY

#Location of BI Bundle file to use as the initial application.  Only used if APPLICATION_TYPE is APPLICATION_TYPE_BI_BUNDLE. 
BI_BUNDLE_FILE=

#Password which secures existing BI archive file
BI_BUNDLE_PASSWORD=<SECURE VALUE>

#New password which will secure AppLite as it is modified with customer data
BI_APP_LITE_PASSWORD=<SECURE VALUE>

#Identifier of initial default service instance if pluggable modules is enabled
BI_DEFAULT_SERVICE_INSTANCE_KEY=bootstrap" > $Software_Location/OAS_Configuration_Response.rsp
}


# Oracle Analytics Server Configuration
configOAS()
{
 echo "Running the OAS Configuration in silent mode....."
 
 mkdir -p $Install_Base_Location/data/domains
 chown -R $User:$Group $Install_Base_Location/data/domains
 cd $Install_Base_Location/app/Oracle/Middleware/Oracle_Home/bi/bin
 ./config.sh -silent -responseFile $Software_Location/OAS_Configuration_Response.rsp -invPtrLoc $Install_Base_Location/app/oraInventory/oraInst.loc
 
 # Check if the Configuration is successful.
 if [[ -d "$Install_Base_Location/data/domains/bi" ]]; then
	echo "OAS Configuration is successful."
 else
	echo "Unable to Configure OAS."
	exit 1
 fi
}


# Define the Default OAS Single Node Ports needed to be opened.
openPorts()
{
 echo "Opening required OAS Ports at the Firewalld."
 
 sudo systemctl status firewalld
 if systemctl list-unit-files | grep -E "firewalld.service.*disabled"; then
   sudo systemctl enable firewalld
   sudo systemctl restart firewalld
 fi
 sudo firewall-cmd --zone=public --permanent --add-port=9500/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9501/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9502/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9503/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9508/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9514/tcp
 sudo firewall-cmd --zone=public --permanent --add-port=9511/tcp
 sudo firewall-cmd --complete-reload
}


# Check the status of the OAS Configuration.
checkStatus()
{
 echo "Checing the Status of OAS Services."
 $Install_Base_Location/data/domains/bi/bitools/bin/status.sh
}


# Test the OAS URL.
testOASURL()
{
 OASHost=`hostname -f`
 curl -k -vvv http://${OASHost}:9502/dv > $Software_Location/result.txt

 if grep -q "302 Moved Temporarily" $Software_Location/result.txt; then
    echo "OAS is up and running successfully!!!."
 else
    echo "Unable to get the status of OAS Check manually!!!"
	echo "Exiting....."
	exit 1
 fi
}


# Clean Up Unwanted Files.
cleanUP()
{
 echo "Cleaning up the unwanted files after the configuration."
 rm -f $Software_Location/OAS_Configuration_Response.rsp
 rm -f $Software_Location/result.txt
}


# Call all Functions
prerequisiteCheck
createOASConfigRespone
configOAS
openPorts
checkStatus
testOASURL
cleanUP
