#!/bin/bash

#---------------------------------------------------------------------
# Enter Variable Values
#---------------------------------------------------------------------
# Specify the user:group installing OAS
User=oracle
Group=oinstall
Software_Location=/tmp/softwares
Install_Base_Location=/u01
# Example value of JDK Version : "1.8.0_421"
JDK_Version="1.8.0_421"
# Single Stack Patch Bundle (SPB) file having FMW, WebLogic and OAC Patches (As of July, 2024.)
OAS_SPB=p36823847_76000_Linux-x86-64.zip
#---------------------------------------------------------------------


# Check if all the required Patches are available.
prerequisiteCheck()
{
 echo "Checking Prerequisites....."
 
 # Check if the user is oracle
 if [ "$(whoami)" != "$User" ]; then
    echo "This script must be run as $User user"
    exit 1
 fi
 
 # Check if the OAS 2024 Stack Patch Bundle (SPB) file available in the required Location or not.
 if [[ -f $Software_Location/$OAS_SPB ]]; then
    echo "OAS 2024 Stack Patch Bundle file exists, Prerequisite Satisfied."
 else
    echo "OAS 2024 Stack Patch Bundle file does not exist, Exiting....."
	exit 1
 fi

 echo "-----------------------------------------------------------------------------------------------------------------------------------------"
 echo " All Stack Patch Bundle files required for Oracle Analytics Server 2024 as of July 2024 are available, proceeding to apply....."
 echo "-----------------------------------------------------------------------------------------------------------------------------------------"
}

# Apply OAS 2024 July Stack Patch Bundle
applyOASSPB()
{
 echo "Applying OAS CPU....."
 
 if [[ -f $Software_Location/$OAS_SPB ]]; then
    cd $Software_Location
    unzip $OAS_SPB
    OAS_SPB_Location=`find $Software_Location -maxdepth 1 -type d -name 'OAS_SPB_*'`
	
    # Check initial version of opatch
    Initial_opatch_version=`$Install_Base_Location/app/Oracle/Middleware/Oracle_Home/OPatch/opatch version`
    echo "Initial $Initial_opatch_version"
 
    # Environment Variables
    export JAVA_HOME=$Install_Base_Location/app/jdk$JDK_Version
    export PATH=$JAVA_HOME/bin:$PATH
 
    # Update the OPtach Version
    cd $OAS_SPB_Location/tools/opatch/generic
    unzip p*_Generic.zip -d /tmp/opatch
    java -jar /tmp/opatch/6880880/opatch_generic.jar -silent oracle_home=$Install_Base_Location/app/Oracle/Middleware/Oracle_Home
 
    # Note: OPatch will be upgraded to 13.9.4.2.15 or later from any version if only running SPBAT -phase apply.
    # To avoid unexpected issues, ensure all prerequisites are met in your environment.
 
    # Check current version of opatch
    Current_opatch_version=`$Install_Base_Location/app/Oracle/Middleware/Oracle_Home/OPatch/opatch version`
    echo "Current $Current_opatch_version"

    # Using SPBAT (Linux)
    cd $OAS_SPB_Location/tools/spbat/generic/SPBAT
		
    # Run the SPBAT utility for the precheck phase
    ./spbat.sh -phase precheck -oracle_home $Install_Base_Location/app/Oracle/Middleware/Oracle_Home
    # SPBAT Apply Phase
    ./spbat.sh -phase apply -oracle_home $Install_Base_Location/app/Oracle/Middleware/Oracle_Home
 elif [[ $OAS_SPB == "" ]]; then
    echo "OAS Stack Patch Bundle is not available, skipping this step."	
 else
    echo "Unable to apply OAS Stack Patch Bundle."
    exit 1
 fi
}


# Clean the Files
cleanUP()
{
 echo "Cleaning up the files used while applying the CPU....."
 
 cd $Software_Location
 rm -f $OAS_SPB
 rm -rf OAS_SPB_*
 rm -f PatchSearch.xml
}


# Call all Functions
prerequisiteCheck
applyOASSPB
cleanUP
