import subprocess
import json
import http.client
import argparse
import os

# REPLACE THE VALUES OF THE FOLLOWING VARIABLES
base64_encoded_clientid_clientsecret="<clientID:ClientSecret enoded string>"
domain="<Domain URL>"
username="<Username>"
password="<Password>"
scope="<Scope of OAC instance from Confidential Application>"
host = "<OAC URL>"

# Define the curl command
curl_command = [
    "curl",
    "-H", f"Authorization: Basic {base64_encoded_clientid_clientsecret}",
    "-H", "Content-Type: application/x-www-form-urlencoded;charset=UTF-8",
    "--request", "POST",
    f"https://{domain}/oauth2/v1/token",
    "-d", f"grant_type=password&username={username}&password={password}&scope={scope}"
]

# Run the curl command
result = subprocess.run(curl_command, capture_output=True, text=True)

output_file = "oac_auth_token_json.txt"

# Write the result to a file
with open(output_file, "w") as file:
    file.write(result.stdout)

print(f"Full response saved to {output_file}")

if result.stderr:
    print(f"Errors encountered:\n{result.stderr}")

# Parse the JSON response to extract the access_token
try:
    response_data = json.loads(result.stdout)
    access_token = response_data.get("access_token")

    if access_token:
        token_file = "oac_auth_token.txt"

        # Write the access_token to the file
        with open(token_file, "w") as file:
            file.write(access_token)

        print(f"Access token saved to {token_file}")

    else:
        print("Access token not found in the response.")
        exit(1)

except json.JSONDecodeError as e:
    print(f"Failed to parse JSON response: {e}")
    exit(1)

if os.path.exists(token_file):
    # Set up argument parser for API request
    parser = argparse.ArgumentParser(description='Get details of folders from OAC using the provided API.')
    parser.add_argument('search_string', type=str, nargs='?', default='*', help='The search string for filtering folders (default: "*")')

    args = parser.parse_args()
    search_string = args.search_string

    # Read the bearer token from the file
    try:
        with open(token_file, 'r') as file:
            bearer_token = file.read().strip()
    except FileNotFoundError:
        print(f"Error: The file '{token_file}' was not found.")
        exit(1)
    except IOError:
        print(f"Error: Could not read the file '{token_file}'.")
        exit(1)

    # Define the API endpoint
    url = f"/api/20210901/catalog/folders?search={search_string}"

    # Define the headers including the authorization header
    headers = {
        "Authorization": f"Bearer {bearer_token}",
        "Content-Type": "application/json"
    }

    # Create a connection
    connection = http.client.HTTPSConnection(host)

    # Send the GET request
    connection.request("GET", url, headers=headers)

    # Get the response
    response = connection.getresponse()
    response_body = response.read().decode("utf-8")

    if response.status == 401:
        print(f"Authorization failed. Status Code: {response.status}")
        print(f"Response Body: {response_body}")
        exit(1)
    try:
        response_data = json.loads(response_body)
        print("Status Code:", response.status)
        print("Response Body:", json.dumps(response_data, indent=4))
    except json.JSONDecodeError as e:
        print(f"Failed to parse JSON response: {e}")
        print(f"Response Body: {response_body}")

    connection.close()

else:
    print(f"Error: The file '{token_file}' does not exist. Please check if the token was saved successfully.")

