cd; 
ls -tr INIT_OA_COMPONENTS*.zip 1>null || { echo "INIT_OA_COMPONENTS zip file not uploaded - returning"; return 1; }

INIT_OA_COMPONENTS_file_name=`ls -tr INIT_OA_COMPONENTS*.zip |tail -1`

[ -d ~/INIT_OA_COMPONENTS ] && rm -rf ~/INIT_OA_COMPONENTS

unzip $INIT_OA_COMPONENTS_file_name INIT_OA_COMPONENTS/*-vars.sh INIT_OA_COMPONENTS/resources/terraform.tfstate || { echo " Unzip of INIT_OA_COMPONENTS zip file failed - returning"; return 2; }

cd ~/INIT_OA_COMPONENTS
source setup-vars.sh || { echo "INIT_OA_COMPONENTS setup-vars.sh failed - returning"; return 3; }

cd ~/INIT_OA_NET_COMPONENTS
source setup-vars.sh || { echo "INIT_OA_NET_COMPONENTS setup-vars.sh failed - returning"; return 4; }


cd resources
terraform init -upgrade || { echo "terraform init failed - returning"; return 5; } 
terraform refresh || { echo "terraform refresh failed - returning"; return 6; } 
terraform apply -target oci_core_vcn.example_vcn -auto-approve || { echo "vcn creation failed - returning"; return 7; } 
terraform apply -auto-approve || { echo "terraform refresh failed - returning"; return 8; }

cd ~/INIT_OA_NET_COMPONENTS
echo "Saving contents ..."
source save-contents.sh >setup-save-contents.log || { echo "INIT_OA_NET_COMPONENTS setup-vars.sh failed - returning"; return 9; }

