resource oci_core_vcn "example_vcn" {
  cidr_blocks = local.example_vcn.cidr_blocks
  compartment_id = local.example_vcn.compartment_id
  display_name = local.example_vcn.display_name
  dns_label    = local.example_vcn.dns_label
}

resource oci_core_subnet "example_private_subnet" {
  compartment_id = local.example_private_subnet.compartment_id
  display_name = local.example_private_subnet.display_name
  dns_label    = local.example_private_subnet.dns_label
  vcn_id = local.example_private_subnet.vcn_id
  cidr_block     = local.example_private_subnet.cidr_block
  prohibit_internet_ingress  = local.example_private_subnet.prohibit_internet_ingress
  prohibit_public_ip_on_vnic = local.example_private_subnet.prohibit_public_ip_on_vnic
}

resource oci_core_service_gateway "example_service_gateway"  {
  compartment_id = local.example_gateways.example_service_gateway.compartment_id
  vcn_id = local.example_gateways.example_service_gateway.vcn_id
  display_name   = "example_service_gateway"
  services {
    service_id = local.example_gateways.example_service_gateway.services.service_id
  }
}
 
resource oci_core_nat_gateway "example_nat_gateway"  {
  compartment_id = local.example_gateways.example_nat_gateway.compartment_id
  vcn_id = local.example_gateways.example_nat_gateway.vcn_id
  display_name   = local.example_gateways.example_nat_gateway.display_name
}  
 
resource "oci_core_drg" "example_drg" {
count = local.oa_region_drg_reference_count
  compartment_id = local.example_gateways.example_drg.compartment_id
  display_name = local.example_drg_name
}

resource "oci_core_drg_attachment" "example_drg_attachment" {
    drg_id = local.example_drg_attachment.drg_id
    display_name = local.example_drg_attachment.display_name
    network_details {
        id = local.example_drg_attachment.network_details.id
        type = local.example_drg_attachment.network_details.type
    }
}
