locals {
example_resolver_endpoint_count = length(local.example_resolver_endpoint)
example_resolver_forwarder_idx = [for k, i in oci_dns_resolver_endpoint.example_resolver_endpoint[*] : k if i.is_forwarding][0]
example_resolver_listener_idx = [for k, i in oci_dns_resolver_endpoint.example_resolver_endpoint[*] : k if i.is_listening][0]

example_resolver_endpoint = [
  {
    is_forwarding = "true"
    is_listening = "false"
    name = local.example_resolver_forwarder_name
    resolver_id = [for each in data.oci_dns_resolvers.example_vcn_resolver.resolvers : each.id if each.attached_vcn_id == oci_core_vcn.example_vcn.id ][0]
    subnet_id = oci_core_subnet.example_private_subnet.id
    scope = "PRIVATE"
  },
  {
    is_forwarding = "false"
    is_listening = "true"
    name = local.example_resolver_listener_name
    resolver_id = [for each in data.oci_dns_resolvers.example_vcn_resolver.resolvers : each.id if each.attached_vcn_id == oci_core_vcn.example_vcn.id ][0]
    subnet_id = oci_core_subnet.example_private_subnet.id
    scope = "PRIVATE"
  }
]



}
