locals {
oa_region_drg_exists = data.oci_core_drgs.oa_region_drg.id != tostring(null) ? true : false
oa_region_drg_id = local.oa_region_drg_exists ? data.oci_core_drgs.oa_region_drg.drgs[0].id : oci_core_drg.example_drg[0].id
oa_region_drg_name = local.oa_region_drg_exists ? data.oci_core_drgs.oa_region_drg.drgs[0].display_name : oci_core_drg.example_drg[0].display_name
oa_region_drg_reference_count = local.oa_region_drg_exists ? 0 : 1
example_drg_name = "Example_DRG"


example_vcn = {
  cidr_blocks = [ "10.8.16.0/24" ]
  compartment_id = local.example_compartment_id
  display_name = local.example_vcn_name
  dns_label    = "examplevcn"
}

example_private_subnet = {
  compartment_id = local.example_compartment_id
  vcn_id = oci_core_vcn.example_vcn.id 
  cidr_block     = "10.8.16.0/26"
  display_name    = local.example_private_subnet_name
  dns_label       = "example"
  prohibit_internet_ingress  = "true"
  prohibit_public_ip_on_vnic = "true"
}

example_gateways = {
    example_service_gateway = {
      compartment_id = local.example_compartment_id
      vcn_id = oci_core_vcn.example_vcn.id 
      display_name   = local.example_service_gateway_name
      services = {
          service_id = [for each in data.oci_core_services.example_services.services[*] : each.id if substr(each.name,0,3) == "All"][0]
      }
    }

    example_nat_gateway = {
      compartment_id = local.example_compartment_id
      vcn_id = oci_core_vcn.example_vcn.id 
      display_name   = local.example_nat_gateway_name
    }

    example_drg = {
     compartment_id = var.TENANCY
     display_name = local.example_drg_name
    }
}

example_drg_attachment = {
    drg_id = local.oa_region_drg_id
    display_name = local.example_drg_attachment_name
    network_details = {
        id = oci_core_vcn.example_vcn.id 
        type = "vcn"
    }
}

}


