resource "oci_dns_resolver_endpoint" "example_resolver_endpoint" {
count = local.example_resolver_endpoint_count
    is_forwarding = local.example_resolver_endpoint[count.index].is_forwarding
    is_listening = local.example_resolver_endpoint[count.index].is_listening
    name = local.example_resolver_endpoint[count.index].name
    resolver_id = local.example_resolver_endpoint[count.index].resolver_id
    subnet_id = local.example_resolver_endpoint[count.index].subnet_id
    scope = local.example_resolver_endpoint[count.index].scope

    timeouts {
      create = "60m"
      delete = "2h"
    }
}
