
locals {

parent_compartment_name = data.oci_identity_compartment.parent_compartment.name
home_region = data.oci_identity_regions.home_region.regions.0.name
tenancy_name = data.oci_identity_tenancy.tenancy.description

example_compartment_name = "Demo_Compartment"
example_compartment_policy_name  = "Example_Compartment_Policy"
example_tenant_policy_name  = "Example_Tenant_Policy"
example_identity_domain_name = "Example_Identity_Domain"
example_admin_user_name = "Example.ServiceAdmin"
assigned_admin_user_group = "Domain_Administrators"
example_token_app_name = "Example_Token_App"
domain_replicated_to_region = local.domain_replication_performed ? var.REGION : "N/A"
policy_group = join ("", [local.example_domain.display_name, "/Domain_Administrators"] )
example_identity_domain_console_url = join("", ["https://cloud.oracle.com/?tenant=", local.tenancy_name, "&domain=", local.example_identity_domain_name, "&region=", var.OA_REGION])


example_identity_domain_url = oci_identity_domain.example_domain.url
example_token_app_auth = base64encode ( join( ":", [local.example_token_app_client_id, local.example_token_app_client_secret] ) )
domain_replication_performed = local.num_identity_domain_replications_required == 1 ? true : false
example_compartment_id = oci_identity_compartment.example_compartment.id
example_identity_domain_id = oci_identity_domain.example_domain.id
example_token_app_id = oci_identity_domains_app.example_token_app.id


}

