locals {


### --------------------------- Compartments ----------------------------------------------
example_compartment = {
    compartment_id = local.parent_compartment_id
    enable_delete = "true"
    description = local.example_compartment_name
    name = local.example_compartment_name
}

### --------------------------- Identiy Domains ----------------------------------------------
num_identity_domain_replications_required = var.REGION == local.home_region ? 0 : 1
example_domain = {
    compartment_id = oci_identity_compartment.example_compartment.id
    description = local.example_identity_domain_name
    display_name = local.example_identity_domain_name
    home_region = local.home_region
    license_type = "free"
    state = "ACTIVE"
    admin_email = local.parent_user_email
    admin_first_name = "Example"
    admin_last_name = "ServiceAdmin"
    admin_user_name = local.example_admin_user_name
    is_hidden_on_login = "true"
    is_notification_bypassed = "false"
    is_primary_email_required = "false"
}

region_replication = {
    domain_id = oci_identity_domain.example_domain.id
# only replicate if the oa region is different than the home region
    replica_region = var.REGION
}

### --------------------------- Policies ----------------------------------------------
compartment_policy_statements  = [ 
join (" ", ["allow group", local.policy_group, "to manage all-resources in compartment", local.example_compartment_name] ),
]

tenant_policy_statements  = [ 
join (" ", ["allow group", local.policy_group, "to manage all-resources in tenancy"] ),
join (" ", ["Allow Group", local.policy_group, "to use cloud-shell-public-network in tenancy"] ),
]

example_policy_count = length(local.example_policies)
example_compartment_policy_idx = [for k, i in oci_identity_policy.example_policies[*] : k if i.name == "Example_Compartment_Policy"][0]
example_tenant_policy_idx = [for k, i in oci_identity_policy.example_policies[*] : k if i.name == "Example_Tenant_Policy"][0]

example_policies = [
  {
    compartment_id = local.parent_compartment_id
    description = local.example_compartment_policy_name
    name = local.example_compartment_policy_name
    statements = local.compartment_policy_statements
  },
  {
    compartment_id = var.TENANCY
    description = local.example_tenant_policy_name
    name = local.example_tenant_policy_name
    statements = local.tenant_policy_statements
  }
]

}
