locals {
compartment_ids = data.oci_identity_compartments.all_compartments.compartments[*].id
compartment_count = local.tenancy_domain_found ? 0 : length(local.compartment_ids)

tenancy_domain_urls = data.oci_identity_domains.tenancy_domains.domains[*].url
tenancy_domain_count = length ( local.tenancy_domain_urls )
tenancy_parent_user_domain_idx = [for k, i in data.oci_identity_domains_user.tenancy_parent_user[*] : k if i.user_id == var.USER]
tenancy_domain_found = length(local.tenancy_parent_user_domain_idx) == 1 ? true : false

compartment_domain_urls = flatten ([for each in data.oci_identity_domains.compartment_domains[*].domains[*] : each[*].url if length(each) > 0 ])
compartment_domain_url_count = local.tenancy_domain_found ? 0 : length(local.compartment_domain_urls)
compartment_parent_user_domain_idx = [for k, i in data.oci_identity_domains_user.compartment_parent_user[*] : k if i.user_id == var.USER]

parent_user_email = local.tenancy_domain_found ? data.oci_identity_domains_user.tenancy_parent_user[local.tenancy_parent_user_domain_idx[0]].emails[0].value : data.oci_identity_domains_user.compartment_parent_user[local.compartment_parent_user_domain_idx[0]].emails[0].value

parent_compartment_id = local.tenancy_domain_found ? data.oci_identity_domains_user.tenancy_parent_user[local.tenancy_parent_user_domain_idx[0]].compartment_ocid : data.oci_identity_domains_user.compartment_parent_user[local.compartment_parent_user_domain_idx[0]].compartment_ocid


example_token_app = {
    active                    = var.identity_domain_app_state
    is_oauth_client           = true
    allowed_grants            = [
        "client_credentials",
        "urn:ietf:params:oauth:grant-type:jwt-bearer",
        "password",
        "refresh_token",
    ]
    allowed_operations        = [
        "onBehalfOfUser",
        "introspect",
    ]
    client_type               = "confidential"
    description               = local.example_token_app_name
    display_name              = local.example_token_app_name
    idcs_endpoint             = local.example_identity_domain_url
    login_mechanism           = "OIDC"
    schemas                   = [
        "urn:ietf:params:scim:schemas:oracle:idcs:App",
        "urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags",
    ]
    based_on_template = {
        value         = "CustomWebAppTemplateId"
        well_known_id = "CustomWebAppTemplateId"
    }
}

example_token_app_client_id = oci_identity_domains_app.example_token_app.name
example_token_app_client_secret = oci_identity_domains_app.example_token_app.client_secret


}
