


resource "oci_identity_compartment" "example_compartment" {
provider       = oci.home
    compartment_id = local.example_compartment.compartment_id
    enable_delete = local.example_compartment.enable_delete
    description = local.example_compartment.description
    name = local.example_compartment.name
}

resource "oci_identity_domain" "example_domain" {
provider       = oci.home
    compartment_id =local.example_domain.compartment_id
    description = local.example_domain.description
    display_name = local.example_domain.display_name
    home_region = local.example_domain.home_region
    license_type = local.example_domain.license_type
    state = var.identity_domain_state
    admin_email = local.example_domain.admin_email
    admin_first_name = local.example_domain.admin_first_name
    admin_last_name = local.example_domain.admin_last_name
    admin_user_name = local.example_domain.admin_user_name
    is_hidden_on_login = local.example_domain.is_hidden_on_login
    is_notification_bypassed = local.example_domain.is_notification_bypassed
    is_primary_email_required = local.example_domain.is_primary_email_required
    timeouts {
      create = "60m"
      delete = "2h"
    }
}

resource "oci_identity_domain_replication_to_region" "region_replication" {
provider = oci.home
# only create if the fa region is different than the home region
  count = local.num_identity_domain_replications_required
    domain_id = local.region_replication.domain_id
    replica_region = local.region_replication.replica_region
    timeouts {
      create = "60m"
      delete = "2h"
    }
}

resource "oci_identity_policy" "example_policies" {
provider = oci.home
count = local.example_policy_count
    compartment_id =local.example_policies[count.index].compartment_id
    description = local.example_policies[count.index].description
    name = local.example_policies[count.index].name
    statements =local.example_policies[count.index].statements 
}

