data "oci_identity_compartments" "all_compartments" {
    compartment_id = var.TENANCY
    access_level = "ACCESSIBLE"
    compartment_id_in_subtree = "true"
    state = "ACTIVE"
}

data "oci_identity_compartment" "parent_compartment" {
    id = local.parent_compartment_id
}

data "oci_identity_domains" "tenancy_domains" {
     compartment_id = var.TENANCY
     state = "ACTIVE"
}

data "oci_identity_domains" "compartment_domains" {
count = local.compartment_count
     compartment_id = local.compartment_ids[count.index]
     state = "ACTIVE"
}

data "oci_identity_tenancy" "tenancy" {
  tenancy_id = var.TENANCY
}

data "oci_identity_regions" "home_region" {
  filter {
    name   = "key"
    values = [data.oci_identity_tenancy.tenancy.home_region_key]
  }
}

#data "oci_identity_domain" "parent_identity_domain" {
#    #Required
#    domain_id = local.parent_identity_domain_id
#}
