resource oci_network_load_balancer_network_load_balancer dns_nlb {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
    #is_preserve_source_destination = "false"
    display_name = var.DNS_NLB_Name
    subnet_id = oci_core_subnet.dns_public_sn.id
    is_private = "false"
}

resource oci_network_load_balancer_backend_set dns_nlb_backend_set {
    #Required
    health_checker {
        #Required
        protocol = "TCP"

        #Optional
        port = "53"
    }
    name = var.DNS_NLB_BE_Set_Name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.dns_nlb.id
    is_preserve_source = "false"
    policy = "FIVE_TUPLE"
}

resource oci_network_load_balancer_backend dns_nlb_backend {
    #Required
    backend_set_name = oci_network_load_balancer_backend_set.dns_nlb_backend_set.name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.dns_nlb.id
    port = "53"

    #Optional
    ip_address = oci_dns_resolver_endpoint.dns_listener.listening_address 
}

resource oci_network_load_balancer_listener dns_nlb_listener {
    #Required
    default_backend_set_name = oci_network_load_balancer_backend_set.dns_nlb_backend_set.name
    name = var.DNS_NLB_Listener_Name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.dns_nlb.id
    port = "53"
    protocol = "TCP_AND_UDP"
}
