## This configuration was generated by terraform-provider-oci

resource oci_dns_view dns_custom_view {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  display_name = var.DNS_Custom_View_Name
}


resource oci_dns_resolver dns_resolver {
  attached_views {
    view_id = oci_dns_view.dns_custom_view.id
  }
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  resolver_id = data.oci_core_vcn_dns_resolver_association.dns_resolver_association.dns_resolver_id
}

resource oci_dns_resolver_endpoint dns_listener {
  endpoint_type = "VNIC"
  is_forwarding     = "false"
  is_listening      = "true"
  name              = var.DNS_Listener_Name
  resolver_id = data.oci_core_vcn_dns_resolver_association.dns_resolver_association.dns_resolver_id
  subnet_id = oci_core_subnet.dns_private_sn.id
  scope = "PRIVATE"
}

resource oci_dns_zone dns_custom_zone {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  name      = var.DNS_Custom_Zone_Name
  scope     = "PRIVATE"
  view_id = oci_dns_view.dns_custom_view.id
  zone_type = "PRIMARY"
}

resource oci_dns_rrset fa_oac_fqdn_a {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  domain = data.terraform_remote_state.iabase.outputs.FA_OAC_FQDN
  items {
    domain = data.terraform_remote_state.iabase.outputs.FA_OAC_FQDN
    rdata  = data.terraform_remote_state.iabase.outputs.FA_OAC_NLB_IP
    rtype  = "A"
    ttl    = "3600"
  }
  rtype = "A"
  scope     = "PRIVATE"
  view_id = oci_dns_view.dns_custom_view.id
  zone_name_or_id = oci_dns_zone.dns_custom_zone.id
}

resource oci_dns_rrset fa_faw_fqdn_a {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  domain = data.terraform_remote_state.iabase.outputs.FA_FAW_FQDN
  items {
    domain = data.terraform_remote_state.iabase.outputs.FA_FAW_FQDN
    rdata  = data.terraform_remote_state.iabase.outputs.FA_FAW_ADW_NLB_IP
    rtype  = "A"
    ttl    = "3600"
  }
  rtype = "A"
  scope     = "PRIVATE"
  view_id = oci_dns_view.dns_custom_view.id
  zone_name_or_id = oci_dns_zone.dns_custom_zone.id
}

resource oci_dns_rrset fa_adw_fqdn_a {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  domain = data.terraform_remote_state.iabase.outputs.FA_ADW_FQDN
  items {
    domain = data.terraform_remote_state.iabase.outputs.FA_ADW_FQDN
    rdata  = data.terraform_remote_state.iabase.outputs.FA_FAW_ADW_NLB_IP
    rtype  = "A"
    ttl    = "3600"
  }
  rtype = "A"
  scope     = "PRIVATE"
  view_id = oci_dns_view.dns_custom_view.id
  zone_name_or_id = oci_dns_zone.dns_custom_zone.id
}
