
resource oci_core_vcn dns_vcn {
  cidr_blocks = [
    var.DNS_VCN_CIDR,
  ]
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  display_name = var.DNS_VCN_Name
  dns_label       = var.DNS_VCN_Label
}

resource oci_core_internet_gateway dns_internet_gateway {
    #Required
   compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
   vcn_id = oci_core_vcn.dns_vcn.id

    #Optional
    display_name = var.DNS_IG_Name
}
resource oci_core_network_security_group dns_nsg {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  display_name = var.DNS_NSG_Name
  vcn_id = oci_core_vcn.dns_vcn.id
}

resource oci_core_subnet dns_public_sn {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = oci_core_vcn.dns_vcn.id
  cidr_block     = var.DNS_Public_SN_CIDR
  display_name    = var.DNS_Public_SN_Name
  dns_label       = var.DNS_Public_SN_Label
  prohibit_internet_ingress  = "false"
  prohibit_public_ip_on_vnic = "false"
  route_table_id             = oci_core_route_table.dns_public_sn_rt.id
  security_list_ids = [
    oci_core_security_list.dns_public_sn_sl.id,
  ]
}

resource oci_core_route_table dns_public_sn_rt {
    #Required
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = oci_core_vcn.dns_vcn.id

    #Optional
    display_name = var.DNS_Public_SN_RT_Name
    route_rules {
        destination       = "0.0.0.0/0"
        destination_type  = "CIDR_BLOCK"
        network_entity_id = oci_core_internet_gateway.dns_internet_gateway.id
    }
}

resource oci_core_security_list dns_public_sn_sl {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = oci_core_vcn.dns_vcn.id
  display_name = var.DNS_Public_SN_SL_Name
  egress_security_rules {
    destination      = "0.0.0.0/0"
    destination_type = "CIDR_BLOCK"
    protocol  = "all"
    stateless = "false"
  }

  ingress_security_rules {
      description = "Customer Forwarder TCP"
      protocol    = "6"
      source      = local.PUBLIC_CIDR
      source_type = "CIDR_BLOCK"
      stateless   = "false"
      tcp_options {
        max = "53"
        min = "53"
      }
    }
  
    ingress_security_rules {
      description = "Customer Forwarder UDP"
      protocol    = "17"
      source      = local.PUBLIC_CIDR
      source_type = "CIDR_BLOCK"
      stateless   = "false"
  }
}

resource oci_core_subnet dns_private_sn {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = oci_core_vcn.dns_vcn.id
  cidr_block     = var.DNS_Private_SN_CIDR
  display_name    = var.DNS_Private_SN_Name
  dns_label       = var.DNS_Private_SN_Label
  prohibit_internet_ingress  = "true"
  prohibit_public_ip_on_vnic = "true"
  route_table_id             = oci_core_vcn.dns_vcn.default_route_table_id
  security_list_ids = [
    oci_core_security_list.dns_private_sn_sl.id,
  ]
}

resource oci_core_security_list dns_private_sn_sl {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = oci_core_vcn.dns_vcn.id
  display_name = var.DNS_Private_SN_SL_Name
  egress_security_rules {
    destination      = "0.0.0.0/0"
    destination_type = "CIDR_BLOCK"
    protocol  = "all"
    stateless = "false"
  }
  ingress_security_rules {
    description = "Public SN TCP"
    protocol    = "6"
    source      = oci_core_subnet.dns_public_sn.cidr_block
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "53"
      min = "53"
    }
  }
  ingress_security_rules {
    description = "Public SN UDP"
    protocol    = "17"
    source      = oci_core_subnet.dns_public_sn.cidr_block
    source_type = "CIDR_BLOCK"
    stateless   = "false"
#    tcp_options {
#      max = "53"
#      min = "53"
#    }
  }
}
