resource "oci_network_load_balancer_network_load_balancer" "fa_oac_nlb" {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
    #is_preserve_source_destination = "false"
    display_name = "FA_OAC_NLB2"
    subnet_id = oci_core_subnet.fa_public_sn.id
    is_private = "false"
}

resource "oci_network_load_balancer_backend_set" "fa_oac_nlb_backend_set" {
    #Required
    health_checker {
        #Required
        protocol = "TCP"

        #Optional
        port = "443"
    }
    name = "FA_OAC_NLB_BE_Set"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_oac_nlb.id
    is_preserve_source = "false"
    policy = "FIVE_TUPLE"
}

resource "oci_network_load_balancer_backend" "fa_oac_nlb_backend" {
    #Required
    backend_set_name = oci_network_load_balancer_backend_set.fa_oac_nlb_backend_set.name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_oac_nlb.id
    port = "443"

    #Optional
    ip_address = data.oci_dns_rrsets.oac_rrsets.rrsets[0].items[0].rdata
}

resource "oci_network_load_balancer_listener" "fa_oac_nlb_listener" {
    #Required
    default_backend_set_name = oci_network_load_balancer_backend_set.fa_oac_nlb_backend_set.name
    name = "FA_OAC_NLB_Listener"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_oac_nlb.id
    port = "443"
    protocol = "TCP"
}

#FAW and ADW
resource "oci_network_load_balancer_network_load_balancer" "fa_faw_adw_nlb" {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
    display_name = "FA_FAW_ADW_NLB"
    subnet_id = oci_core_subnet.fa_public_sn.id
    is_private = "false"
}

# FAW
resource "oci_network_load_balancer_backend_set" "fa_faw_nlb_backend_set" {
    #Required
    health_checker {
        #Required
        protocol = "TCP"

        #Optional
        port = "443"
    }
    name = "FA_FAW_NLB_BE_Set"
    is_preserve_source = "false"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    policy = "FIVE_TUPLE"
}

resource "oci_network_load_balancer_backend" "fa_faw_nlb_backend" {
    #Required
    backend_set_name = oci_network_load_balancer_backend_set.fa_faw_nlb_backend_set.name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    port = "443"

    #Optional
    ip_address = data.oci_dns_rrsets.faw_rrsets.rrsets[0].items[0].rdata
}

resource "oci_network_load_balancer_listener" "fa_faw_nlb_listener" {
    #Required
    default_backend_set_name = oci_network_load_balancer_backend_set.fa_faw_nlb_backend_set.name
    name = "FA_FAW_NLB_Listener"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    port = "443"
    protocol = "TCP"
}

#ADW
resource "oci_network_load_balancer_backend_set" "fa_adw_nlb_backend_set" {
    #Required
    health_checker {
        #Required
        protocol = "TCP"

        #Optional
        port = "1522"
    }
    name = "FA_ADW_NLB_BE_Set"
    is_preserve_source = "false"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    policy = "FIVE_TUPLE"
}

resource "oci_network_load_balancer_backend" "fa_adw_nlb_backend" {
    #Required
    backend_set_name = oci_network_load_balancer_backend_set.fa_adw_nlb_backend_set.name
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    port = "1522"

    #Optional
    ip_address = data.oci_dns_rrsets.adw_rrsets.rrsets[0].items[0].rdata
}

resource "oci_network_load_balancer_listener" "fa_adw_nlb_listener" {
    #Required
    default_backend_set_name = oci_network_load_balancer_backend_set.fa_adw_nlb_backend_set.name
    name = "FA_ADW_NLB_Listener"
    network_load_balancer_id = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.id
    port = "1522"
    protocol = "TCP"
}
