resource "local_file" "hosts" {
content  = <<EOT
${local.hosts_line1}
${local.hosts_line2}
EOT
filename = local.hosts_filename
} 




locals { 
Tenancy_Name = data.terraform_remote_state.prepare.outputs.Tenancy_Name
Region_Name = data.terraform_remote_state.prepare.outputs.FA_Region

FA_Instance_Name0 = split ( "-", data.oci_dns_rrsets.oac_rrsets.rrsets[0]["domain"] )
FA_Instance_Name = substr(local.FA_Instance_Name0[0],3,-1) 
FAW_Domain_Search = join( "-", [local.FA_Instance_Name, local.Tenancy_Name] )
FA_ADW_Domain_Name = join(".", ["adb", local.Region_Name, "oraclecloud.com"] )

FA_OAC_FQDN = data.oci_dns_rrsets.oac_rrsets.rrsets[0]["domain"]
FA_FAW_FQDN = data.oci_dns_rrsets.faw_rrsets.rrsets[0]["domain"]
FA_ADW_FQDN = data.oci_dns_rrsets.adw_rrsets.rrsets[0]["domain"]

FA_URL_MESSAGE = "Use these URLS to access Fusion Analytics"
FA_OAC_URL = join("", ["https://", local.FA_OAC_FQDN, "/ui/dv"] )
FA_FAW_URL = join("", ["https://", local.FA_FAW_FQDN, "/ui/oax"] )

oac_nlb_iplist = oci_network_load_balancer_network_load_balancer.fa_oac_nlb.ip_addresses[*]
oac_nlb_iplist2 = [for each in local.oac_nlb_iplist : each if each.is_public == true]
FA_OAC_NLB_IP = local.oac_nlb_iplist2[0]["ip_address"]

faw_nlb_iplist = oci_network_load_balancer_network_load_balancer.fa_faw_adw_nlb.ip_addresses[*]
faw_nlb_iplist2 = [for each in local.faw_nlb_iplist : each if each.is_public == true]
FA_FAW_ADW_NLB_IP = local.faw_nlb_iplist2[0]["ip_address"]

hosts_filename = join ("/", [var.HOME, "hosts"] )
hosts_line1 = join (" ", [local.FA_OAC_NLB_IP, local.FA_OAC_FQDN] )
hosts_line2 = join (" ", [local.FA_FAW_ADW_NLB_IP, local.FA_FAW_FQDN, local.FA_ADW_FQDN] )

PUBLIC_CIDR = join (".", [var.PUBLIC_CIDR0, "0", "0/16"] )
}

