data "oci_dns_zones" "adw_zones" {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID

    #Optional
    scope = "PRIVATE"
    name_contains = local.FA_ADW_Domain_Name
}

data "oci_dns_rrsets" "adw_rrsets" {
    #Required
    zone_name_or_id = data.oci_dns_zones.adw_zones.zones.0.id

    #Optional
    rtype = "A"
}

data "oci_dns_zones" "oac_zones" {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID

    #Optional
    scope = "PRIVATE"
    name_contains = "ocp.oraclecloud.com"
}

data "oci_dns_rrsets" "oac_rrsets" {
    #Required
    zone_name_or_id = data.oci_dns_zones.oac_zones.zones.0.id

    #Optional
    rtype = "A"
}

data "oci_dns_zones" "faw_zones" {
    #Required
    compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID

    #Optional
    scope = "PRIVATE"
    name_contains = local.FAW_Domain_Search
}

data "oci_dns_rrsets" "faw_rrsets" {
    #Required
    zone_name_or_id = data.oci_dns_zones.faw_zones.zones.0.id

    #Optional
    rtype = "A"
}
