## This configuration was generated by terraform-provider-oci

resource "oci_core_internet_gateway" "fa_internet_gateway" {
    #Required
#  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
   compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
#  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID
   vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID

    #Optional
    display_name = var.FA_IG_Name
}

resource "oci_core_route_table" "fa_public_rt" {
    #Required
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID

    #Optional
    display_name = var.FA_Public_RT_Name
    route_rules {
        destination       = "0.0.0.0/0"
        destination_type  = "CIDR_BLOCK"
        network_entity_id = oci_core_internet_gateway.fa_internet_gateway.id
    }
}

resource oci_core_security_list fa_public_sn_sl {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID
  display_name = var.FA_Public_SN_SL_Name
  egress_security_rules {
    destination      = "0.0.0.0/0"
    destination_type = "CIDR_BLOCK"
    protocol  = "all"
    stateless = "false"
  }

  ingress_security_rules {
    description = "User Public IP"
    protocol    = "6"
    source      = local.PUBLIC_CIDR
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "443"
      min = "443"
    }
  }

ingress_security_rules {
    description = "User Public IP"
    protocol    = "6"
    source      = local.PUBLIC_CIDR
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "1522"
      min = "1522"
    }
  }

  ingress_security_rules {
    description = "User Public IP"
    protocol    = "6"
    source      = local.PUBLIC_CIDR
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "443"
      min = "443"
    }
  }
}

resource oci_core_subnet fa_public_sn {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID
  cidr_block     = "10.50.64.0/26"
  display_name    = var.FA_Public_SN_Name
  dns_label       = "favcnpubsn"
  prohibit_internet_ingress  = "false"
  prohibit_public_ip_on_vnic = "false"
  route_table_id             = oci_core_route_table.fa_public_rt.id
  security_list_ids = [
    oci_core_security_list.fa_public_sn_sl.id,
  ]
}

resource oci_core_security_list fa_private_sn_sl2 {
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID
  display_name = var.FA_Private_SN_SL_Name2

  ingress_security_rules {
    description = "Public subnet"
    protocol    = "6"
    source      = oci_core_subnet.fa_public_sn.cidr_block
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "443"
      min = "443"
    }
  }
ingress_security_rules {
    description = "Public subnet"
    protocol    = "6"
    source      = oci_core_subnet.fa_public_sn.cidr_block
    source_type = "CIDR_BLOCK"
    stateless   = "false"
    tcp_options {
      max = "1522"
      min = "1522"
    }
  }
}

resource oci_core_subnet fa_private_sn {
  lifecycle { prevent_destroy = true }
  compartment_id = data.terraform_remote_state.prepare.outputs.FA_Compartment_ID
  vcn_id = data.terraform_remote_state.prepare.outputs.FA_VCN_ID
  cidr_block     = "10.50.0.0/26"
  security_list_ids = [
    data.terraform_remote_state.prepare.outputs.FA_Private_SN_SL_ID,
    oci_core_security_list.fa_private_sn_sl2.id,
  ]
}
