resource oci_analytics_analytics_instance_private_access_channel "example_oac_pac" {
count = local.example_oac_pac_count
    analytics_instance_id = local.example_oac_pac[count.index].analytics_instance_id
    subnet_id = local.example_oac_pac[count.index].subnet_id
    vcn_id = local.example_oac_pac[count.index].vcn_id
    display_name = local.example_oac_pac[count.index].display_name
 
    dynamic "private_source_dns_zones" {
      for_each = local.example_oac_pac[count.index].private_source_dns_zones[*]
        content {
          dns_zone = private_source_dns_zones.value["dns_zone"]
          description = private_source_dns_zones.value["description"]
        }
    } 
   timeouts {
      create = "60m"
      delete = "2h"
    }
}

