
clear;
read -sp 'Enter the Example.ServiceAdmin password (It is not revealed) and press return: ' passvar

cd $MODULE_HOME/resources ; 

uservar=`terraform state show data.terraform_remote_state.INIT_OA_COMPONENTS |grep example_admin_user_name |cut -d '"' -f2`
id_url=`terraform state show data.terraform_remote_state.INIT_OA_COMPONENTS |grep example_identity_domain_url |cut -d '"' -f2`
basic_auth=`terraform state show data.terraform_remote_state.INIT_OA_COMPONENTS |grep z_example_token_app_auth |cut -d '"' -f2`

cd $MODULE_HOME

header_auth=`echo -H \"Authorization: Basic $basic_auth\"`
header_content=`echo -H \"Content-Type: application/x-www-form-urlencoded\;charset=UTF-8\"`
request_post=`echo '--request POST' $id_url/oauth2/v1/token`
post_data=`echo -d \"grant_type=password\&scope=urn:opc:idm:__myscopes__\&username=$uservar\&password=$passvar\"`

echo curl -s $header_auth $header_content $request_post $post_data  >tokencommand.sh
source tokencommand.sh | awk -F"\"" '{print $4}' >tokentext

# Obtain the new value of the TOKEN variable
source ~/.bashrc

cd $MODULE_HOME/resources

