--------------------------------------------------------------------------------------------
-- Create and populate a sample table
--------------------------------------------------------------------------------------------
DROP TABLE swipe_test_table;
CREATE TABLE swipe_test_table (user_id      NUMBER, 
                               building_id  VARCHAR2(100), 
                               floor_id     VARCHAR2(100), 
                               room_id      VARCHAR2(100), 
                               swipe_in_out VARCHAR2(5), 
                               time         DATE);

INSERT INTO swipe_test_table VALUES (1, 'BUILDING_1', NULL, 'ROOM_1', 'IN',  to_date('280220 13:00:00','DDMMYY HH24:MI:SS')); 
INSERT INTO swipe_test_table VALUES (1, 'BUILDING_1', NULL, 'ROOM_1', 'OUT', to_date('280220 14:00:00','DDMMYY HH24:MI:SS')); 

INSERT INTO swipe_test_table VALUES (1, 'BUILDING_1', NULL, 'ROOM_2', 'IN',  to_date('280220 16:00:00','DDMMYY HH24:MI:SS')); 
INSERT INTO swipe_test_table VALUES (1, 'BUILDING_1', NULL, 'ROOM_2', 'OUT', to_date('280220 17:00:00','DDMMYY HH24:MI:SS')); 

INSERT INTO swipe_test_table VALUES (2, 'BUILDING_1', NULL, 'ROOM_1', 'IN',  to_date('280220 12:30:00','DDMMYY HH24:MI:SS')); 
INSERT INTO swipe_test_table VALUES (2, 'BUILDING_1', NULL, 'ROOM_1', 'OUT', to_date('280220 13:30:00','DDMMYY HH24:MI:SS')); 

INSERT INTO swipe_test_table VALUES (2, 'BUILDING_1', NULL, 'ROOM_2', 'IN',  to_date('280220 16:20:00','DDMMYY HH24:MI:SS')); 
INSERT INTO swipe_test_table VALUES (2, 'BUILDING_1', NULL, 'ROOM_2', 'OUT', to_date('280220 16:40:00','DDMMYY HH24:MI:SS')); 

INSERT INTO swipe_test_table VALUES (3, 'BUILDING_1', NULL, 'ROOM_1', 'IN',  to_date('280220 12:00:00','DDMMYY HH24:MI:SS')); 
INSERT INTO swipe_test_table VALUES (3, 'BUILDING_1', NULL, 'ROOM_1', 'OUT', to_date('280220 15:00:00','DDMMYY HH24:MI:SS')); 

COMMIT;


--------------------------------------------------------------------------------------------
-- Create indexes
--------------------------------------------------------------------------------------------
CREATE INDEX swipe_test_table_user_id_idx ON swipe_test_table(user_id);
CREATE INDEX swipe_test_table_time_idx    ON swipe_test_table(time);


---------------------------------------------
-- If running in SQL*Plus, format the output
---------------------------------------------
column building_id format a11
column floor_id    format a11
column room_id     format a11
set pagesize 1000
set lines 200

--------------------------------------------------------------------------------------------
-- Find people that shared the same room at the same time , and report metrics like duration
-- This example finds anyone that shared a room with user1 between 8am and 8 pm
--    Report each individal room with segment_or_all = 'SEGMENT'
--------------------------------------------------------------------------------------------
SELECT a.in_user_id, 
       a.out_user_id,
       a.building_id,
       a.room_id,
       to_char(a.start_time,'DDMMYY HH24:MI:SS') as start_time,
       to_char(a.end_time,'DDMMYY HH24:MI:SS')   as end_time,
       round(a.duration/60, 2)                   as duration_in_min
FROM TABLE (sdo_obj_tracing.get_all_swipe_io_durations (
              user_id                    => 1,
              start_time                 => to_date('280220 08:00:00','DDMMYY HH24:MI:SS'),
              end_time                   => to_date('280220 20:00:00','DDMMYY HH24:MI:SS'),
              track_table_name           => 'swipe_test_table',
              user_id_column_name        => 'user_id',
              building_id_column_name    => 'building_id',
              floor_id_column_name       => 'floor_id',        -- optional
              room_id_column_name        => 'room_id',         -- optional
              swipe_io_column_name       => 'swipe_in_out',
              time_column_name           => 'time')) a          -- optional
WHERE segment_or_all = 'SEGMENT'
ORDER BY in_user_id, out_user_id, start_time;


---------------------------------------------------------------------------------------------------------
-- Find people that shared the same room at the same time , and report metrics like duration
-- Find anyone that shared a room with user1 between 8am and 8 pm 
--    Report summary with segment_or_all = 'ALL'
---------------------------------------------------------------------------------------------------------
SELECT a.in_user_id, 
       a.out_user_id,
       to_char(a.start_time,'DDMMYY HH24:MI:SS') as start_time,
       to_char(a.end_time,'DDMMYY HH24:MI:SS')   as end_time,
       round(a.duration/60, 2)                   as duration_in_min,
       a.num_contact_times
FROM TABLE (sdo_obj_tracing.get_all_swipe_io_durations (
              user_id                    => 1,
              start_time                 => to_date('280220 08:00:00','DDMMYY HH24:MI:SS'),
              end_time                   => to_date('280220 20:00:00','DDMMYY HH24:MI:SS'),
              track_table_name           => 'swipe_test_table',
              user_id_column_name        => 'user_id',
              building_id_column_name    => 'building_id',
              floor_id_column_name       => 'floor_id',        -- optional
              room_id_column_name        => 'room_id',         -- optional
              swipe_io_column_name       => 'swipe_in_out',
              time_column_name           => 'time')) a          -- optional
WHERE segment_or_all = 'ALL'
ORDER BY in_user_id, out_user_id, start_time;
