----------------------------------------------------------------
-- Load associated gps_track_data.dmp file first.
-- Ordinaty exp file, not datapump.
--   
-- Non-spatial and spatial indexes have been precreated on 
--   osm_tracks tabe included in the dump file
----------------------------------------------------------------
imp username/password file=gps_track_data.dmp full=y

-----------------------------------------------------
-- Commands to format output if running from SQL*Plus
-----------------------------------------------------
set pagesize 1000
set linesize 150

--------------------------------------------------------------------------------------------
-- Example with segment_or_all = 'ALL'
--
-- Find users whose track points coincide with a specified user's track points 
--    within a giving proximity and time.
--
-- This example find all user's whose track points coincide within 15 meters and 5 seconds
--   of user_id 7's track points.
--
-- **NOTE** time_tolerance_in_sec should be a function of the data collection rate.
--          If gps track points are collected every 1 or 2 seconds, time_tolerance_in_sec
--          should be about 2x the collection rate... or in this example, 5 seconds.
--
--          For example, if gps track points are collected every 30 seconds, 
--          time_tolerance_in_sec should be between 60 and 90 seconds, 
--          or about 1.5x or 2x the collection rate.
--
--          chaning_tolerance_in_sec should equal to or larger than time_tolerance_in_sec.
--
-- This example reports uses segment_or_all = 'ALL', which reports 1 row for each 
--    user that came in contact with user 7.  It reports how many times contact was made,
--    In this example, user 6 came in contact with user 7 thirty four times, and the 
--    duration total of all thirty four interactions is reported.
--
--    Selecting the geometry is optional
--------------------------------------------------------------------------------------------
SELECT a.in_user_id
      ,a.out_user_id
      ,round(a.duration/60,2) duration_in_minutes
      ,to_char(a.start_time,'MM/DD/YY HH24:MI:SS') start_time
      ,to_char(a.end_time, 'MM/DD/YY HH24:MI:SS')  end_time
      ,a.num_contact_times
--      ,a.geom
FROM TABLE(sdo_obj_tracing.get_all_durations(
                             user_id                    => 7,
                             start_time                 => to_date('31-MAY-2020 00.00.03','DD-MON-YYYY HH24.MI.SS'),
                             end_time                   => to_date('31-MAY-2020 23.59.54','DD-MON-YYYY HH24.MI.SS'),
                             distance                   => 15,
                             time_tolerance_in_sec      => 5,
                             chaining_tolerance_in_sec  => 20,
                             track_table_name           => 'osm_tracks_new',
                             geom_column_name           => 'geom',
                             user_id_column_name        => 'user_id',
                             time_column_name           => 'time_adjusted',
                             date_as_number_column_name => 'time_adjusted_as_number')) a
WHERE a.segment_or_all = 'ALL'
ORDER BY a.in_user_id, a.out_user_id, a.start_time;


--------------------------------------------------------------------------------------------
-- Example with segment_or_all = 'SEGMENT'
--
-- Find users whose track points coincide with a specified user's track points 
--    within a giving proximity and time.
--
-- This example find all user's whose track points coincide within 15 meters and 5 seconds
--   of user_id 7's track points.
--
-- **NOTE** time_tolerance_in_sec should be a function of the data collection rate.
--          If gps track points are collected every 1 or 2 seconds, time_tolerance_in_sec
--          should be about 2x the collection rate... or in this example, 5 seconds.
--
--          For example, if gps track points are collected every 30 seconds, 
--          time_tolerance_in_sec should be between 60 and 90 seconds, 
--          or about 1.5x or 2x the collection rate.
--
--          chaning_tolerance_in_sec should equal to or larger than time_tolerance_in_sec.
--
-- This example reports uses segment_or_all = 'SEGMENT', which reports 1 row for each time a
--    user that came in contact with user 7.
--    In this example, user 6 came in contact with user 7 thirty four times, and the 
--    each of the thirty four interactions is reported with it's respective duration.
--
--    Selecting the geometry is optional
--------------------------------------------------------------------------------------------
SELECT a.in_user_id
      ,a.out_user_id
      ,round(a.duration/60,2) duration_in_minutes
      ,to_char(a.start_time,'MM/DD/YY HH24:MI:SS') start_time
      ,to_char(a.end_time, 'MM/DD/YY HH24:MI:SS') end_time
      ,a.num_contact_times
--      ,a.geom
FROM TABLE(sdo_obj_tracing.get_all_durations(
                             user_id                    => 7,
                             start_time                 => to_date('31-MAY-2020 00.00.03','DD-MON-YYYY HH24.MI.SS'),
                             end_time                   => to_date('31-MAY-2020 23.59.54','DD-MON-YYYY HH24.MI.SS'),
                             distance                   => 15,
                             time_tolerance_in_sec      => 5,
                             chaining_tolerance_in_sec  => 20,
                             track_table_name           => 'osm_tracks_new',
                             geom_column_name           => 'geom',
                             user_id_column_name        => 'user_id',
                             time_column_name           => 'time_adjusted',
                             date_as_number_column_name => 'time_adjusted_as_number')) a
WHERE a.segment_or_all = 'SEGMENT'
ORDER BY a.in_user_id, a.out_user_id, a.start_time;
