##############################################################################
# Set of common utility functions used by the other Demo scripts.
# 
# This includes functions for
# - adding harvested types to the WLDF configuration, by type or instance,
#   with our without attributes specified
# - creating, targeting, of WLDFSystemResourceMBean
# - untargeting and destroy of WLDFSystemResourceMBean
#
##############################################################################
import sys
import os
import socket
# from optparse import OptionParser

print ""
print "Setting up demo common vars and functions"
print ""

working_dir=os.getcwd()

#
# Create the server template for the dynamic servers and set the attributes for
# the dynamic servers. Setting the cluster is not required.
#
machineName=socket.gethostname()

domain_name='elasticity_domain'
domain_dir=working_dir + "/elasticity_domain"

adminName="AdminServer"
clusterName="DynamicCluster"
templateName=clusterName+"-server-template"
serverPrefix=clusterName+"-"

username="weblogic";
passwd="welcome1"

adminHost=socket.gethostname()
adminPort='20001'
serverURL="t3://"+adminHost+":"+adminPort

# Retrieve a positional argument if it exists; if not,
# the provided default is returned.
#
# Params:
# pos   The integer location in sys.argv of the parameter
# default  The default value to return if the parameter does not exist
#
# returns the value at sys.argv[pos], or the provided default if necesssary
def getPositionalArgument(pos, default):
  value=None
  try:
    value=sys.argv[pos]
  except:
    value=default
  return value

def connectToServer():
  global serverURL
  global username
  global passwd
  global connected
  global adminHost
  global adminPort
  
  username=getPositionalArgument(1, username)
  passwd=getPositionalArgument(2, passwd)
  
  adminHost=getPositionalArgument(3, adminHost)
  adminPort=getPositionalArgument(4, adminPort)
  
  serverURL="t3://"+adminHost+":"+adminPort

  if connected == "true":
    print "Already connected to server"
  else:
    connect(username,passwd,serverURL)
    
