import os
import sys

execfile('common.py')

domain_user = sys.argv[1]
domain_pass = sys.argv[2]
mw_home = os.environ['MW_HOME']

#=======================================================================================
# Open a domain template.
#=======================================================================================

readTemplate(mw_home + "/wlserver/common/templates/wls/wls.jar")

#=======================================================================================
# Configure the Administration Server and SSL port.
#
# To enable access by both local and remote processes, you should not set the 
# listen address for the server instance (that is, it should be left blank or not set). 
# In this case, the server instance will determine the address of the machine and 
# listen on it. 
#=======================================================================================

cd('Servers/AdminServer')
set('ListenAddress','')
set('ListenPort', 20001)

create('AdminServer','SSL')
cd('SSL/AdminServer')
set('Enabled', 'True')
set('ListenPort', 20002)

#=======================================================================================
# Define the user password for weblogic.
#=======================================================================================

cd('/')
cd('Security/base_domain/User/' + domain_user)
cmo.setPassword(domain_pass)

#=======================================================================================
# Write the domain and close the domain template.
#=======================================================================================

setOption('OverwriteDomain', 'true')
writeDomain(domain_dir)
closeTemplate()

#=======================================================================================
# Exit WLST.
#=======================================================================================

exit()

