##############################################################################
# Set of common utility functions used by the other Demo scripts.
# 
# This includes functions for
# - adding harvested types to the WLDF configuration, by type or instance,
#   with our without attributes specified
# - creating, targeting, of WLDFSystemResourceMBean
# - untargeting and destroy of WLDFSystemResourceMBean
#
##############################################################################
import sys
# from optparse import OptionParser

print ""
print "Setting up demo common vars and functions"
print ""

#
# Create the server template for the dynamic servers and set the attributes for
# the dynamic servers. Setting the cluster is not required.
#
machineName="localhost"
clusterName="DynamicCluster"
templateName=clusterName+"-server-template"
serverPrefix=clusterName+"-"

username="weblogic";
passwd="welcome1"

adminHost='localhost'
adminPort='20001'
serverURL="t3://"+adminHost+":"+adminPort

otdConfig='elasticity-otd'
otdInstance="otd_elasticity-otd_localhost"

otdOriginServer='localhost:8001'
otdListenerPort='20009'

# Retrieve a positional argument if it exists; if not,
# the provided default is returned.
#
# Params:
# pos   The integer location in sys.argv of the parameter
# default  The default value to return if the parameter does not exist
#
# returns the value at sys.argv[pos], or the provided default if necesssary
def getPositionalArgument(pos, default):
  value=None
  try:
    value=sys.argv[pos]
  except:
    value=default
  return value

# def getOptions():
#   parser=OptionParser();
#   parser.add_option("-u","--user", action="store", dest="username", default="weblogic", help="Admin username")
#   parser.add_option("-p","--pass", action="store", dest="password", default="welcome1", help="Admin password")
#   parser.add_option("-s","--server", action="store", dest="serverURL", default="t3://localhost:20001", help="Admin server URL")
#   return parser

def connectToServer():
  global serverURL
  global username
  global passwd
  global connected
  global adminHost
  global adminPort
  
  username=getPositionalArgument(1, username)
  passwd=getPositionalArgument(2, passwd)
  
  adminHost=getPositionalArgument(3, adminHost)
  adminPort=getPositionalArgument(4, adminPort)
  
  serverURL="t3://"+adminHost+":"+adminPort
#   connect(username,passwd,serverURL)

  if connected == "true":
    print "Already connected to server"
  else:
    connect(username,passwd,serverURL)
    
