
execfile('common.py')

connectToServer()

edit()
startEdit()

try:
  
  print 'server:' + serverName

  #
  # Set the cooloff period to 120 secs
  #
  dynCluster=cmo.lookupCluster(clusterName)
  dynServers=dynCluster.getDynamicServers()
  dynServers.setDynamicClusterCooloffPeriodSeconds(120)
  
  resName='ClusterManager'
  resMB=cmo.lookupWLDFSystemResource(resName)
  if resMB == None:
    print "Creating resource " + resName + " and targeting to " + serverName
    resMB=cmo.createWLDFSystemResource(resName)
    server=cmo.lookupServer(serverName)
    resMB.addTarget(server)
    
  res=resMB.getWLDFResource()
  wn=res.getWatchNotification()

  scaleUp=wn.lookupScaleUpAction('scaleUp')
  if scaleUp == None:
    print "Creating scale up action"
    scaleUp=wn.createScaleUpAction('scaleUp')
  scaleUp.setScalingSize(1)
  scaleUp.setClusterName(clusterName)

  scaleDown=wn.lookupScaleDownAction('scaleDown')
  if scaleDown == None:
    print "Creating scale down action"
    scaleDown=wn.createScaleDownAction('scaleDown')
  scaleDown.setScalingSize(1)
  scaleDown.setClusterName(clusterName)

  high=wn.lookupWatch('highMark')
  if high == None:
    print "Creating policy-based High Mark watch"
    high=wn.createWatch('highMark')
  high.setRuleType('Harvester')
  high.setExpressionLanguage('EL')
  high.getSchedule().setMinute('*')
  high.getSchedule().setSecond('*/10')
  high.setAlarmType('AutomaticReset')
  high.setAlarmResetPeriod(150000)
  high.setRuleExpression("wls:ClusterHighThroughput('"+clusterName+"', '10s', '30s', 250, 60)")
  high.addNotification(scaleUp)
  high.setEnabled(true)

  low=wn.lookupWatch('lowMark')
  if low == None:
    print "Creating policy-based Low Mark watch"
    low=wn.createWatch('lowMark')
  low.setRuleType('Harvester')
  low.setExpressionLanguage('EL')
  low.getSchedule().setMinute('*')
  low.getSchedule().setSecond('*/10')
  low.setAlarmType('AutomaticReset')
  low.setAlarmResetPeriod(60000)
  low.setRuleExpression("wls:ClusterLowThroughput('"+clusterName+"', '10s', '60s', 50, 75)")
  low.addNotification(scaleDown)
  low.setEnabled(true)

  calendarScaleUp=wn.lookupWatch('ChristmasReturnsScaleUpWatch')
  if calendarScaleUp == None:
    print "Creating scale-up for the post-Christmas returns rush on Dec 26 at 3am"
    calendarScaleUp=wn.createWatch('ChristmasReturnsScaleUpWatch')
  calendarScaleUp.setRuleType('Harvester')
  calendarScaleUp.setExpressionLanguage('EL')
  calendarScaleUp.getSchedule().setHour('3')
  calendarScaleUp.getSchedule().setMinute('0')
  calendarScaleUp.getSchedule().setSecond('0')
  calendarScaleUp.getSchedule().setDayOfMonth('26')
  calendarScaleUp.getSchedule().setMonth('Dec')
  calendarScaleUp.setEnabled(false)
  calendarScaleUp.addNotification(scaleUp)
   
  calendarScaleDown=wn.lookupWatch('PostChristmasReturnsScaleDownWatch')
  if calendarScaleDown == None:
    print "Creating scale-down when the Christmas returns season ends on Jan 15 at midnight"
    calendarScaleDown=wn.createWatch('PostChristmasReturnsScaleDownWatch')
  calendarScaleDown.setRuleType('Harvester')
  calendarScaleDown.setExpressionLanguage('EL')
  calendarScaleDown.getSchedule().setHour('0')
  calendarScaleDown.getSchedule().setMinute('0')
  calendarScaleDown.getSchedule().setSecond('0')
  calendarScaleDown.getSchedule().setDayOfMonth('15')
  calendarScaleDown.getSchedule().setMonth('Jan')
  calendarScaleDown.setEnabled(false)
  calendarScaleDown.addNotification(scaleDown)
 
  print "Activating resource..."
  save()
  activate()
  print "Resource activated"
  
except:
  if editService.getConfigurationManager().isEditor():
    cancelEdit('y')
  raise

print "Done"

