#!/bin/sh

# WARNING: This file is created by the Configuration Wizard.
# Any changes to this script may be lost when adding extensions to this configuration.

# --- Start Functions ---

BP=100
SP=$BP

pushd()
{
	if [ -z "$1" ]
	then
		return
	fi

	SP=`expr $SP - 1`
	eval _stack$SP=`pwd`
	cd $1
	return
}

popd()
{
	if [ $SP -eq $BP ]
	then
		return
	fi
	eval cd \${_stack$SP}
	SP=`expr $SP + 1`
	return
}


# --- End Functions ---

# *************************************************************************
# This script is used to setup the needed environment to be able to start Weblogic Server in this domain.
# 
# This script initializes the following variables before calling commEnv to set other variables:
# 
# WL_HOME         - The BEA home directory of your WebLogic installation.
# JAVA_VM         - The desired Java VM to use. You can set this environment variable before calling
#                   this script to switch between Sun or BEA or just have the default be set. 
# JAVA_HOME       - Location of the version of Java used to start WebLogic
#                   Server. Depends directly on which JAVA_VM value is set by default or by the environment.
# USER_MEM_ARGS   - The variable to override the standard memory arguments
#                   passed to java.
# PRODUCTION_MODE - The variable that determines whether Weblogic Server is started in production mode.
# DOMAIN_PRODUCTION_MODE 
#                 - The variable that determines whether the workshop related settings like the debugger,
#                   testconsole or iterativedev should be enabled. ONLY settable using the 
#                   command-line parameter named production
#                   NOTE: Specifying the production command-line param will force 
#                          the server to start in production mode.
# WLS_POLICY_FILE - Java policy file to use. Set this environment variable to specify a policy file.
#                   Otherwise this script will assign a default value.
# 
# Other variables used in this script include:
# SERVER_NAME     - Name of the weblogic server.
# JAVA_OPTIONS    - Java command-line options for running the server. (These
#                   will be tagged on to the end of the JAVA_VM and
#                   MEM_ARGS)
# PROXY_SETTINGS  - These are tagged on to the end of the JAVA_OPTIONS. This variable is deprecated and should not
#                   be used. Instead use JAVA_OPTIONS
# 
# For additional information, refer to "Administering Server Startup and Shutdown for Oracle WebLogic Server"
# *************************************************************************

WL_HOME="@WL_HOME"
export WL_HOME

BEA_JAVA_HOME=""
export BEA_JAVA_HOME

DEFAULT_BEA_JAVA_HOME=""
export DEFAULT_BEA_JAVA_HOME

SUN_JAVA_HOME="@SUN_JAVA_HOME"
export SUN_JAVA_HOME

DEFAULT_SUN_JAVA_HOME="@SUN_JAVA_HOME"
export DEFAULT_SUN_JAVA_HOME

if [ "${SUN_JAVA_HOME}" = "" ] ; then
SUN_JAVA_HOME="@SUN_JAVA_HOME"
	export SUN_JAVA_HOME
fi

if [ "${BEA_JAVA_HOME}" = "" ] ; then
BEA_JAVA_HOME="@BEA_JAVA_HOME"
	export BEA_JAVA_HOME
fi

if [ "${VM_TYPE}" = "JRockit" ] ; then
	JAVA_HOME="${BEA_JAVA_HOME}"
	export JAVA_HOME
else
	if [ "${JAVA_VENDOR}" = "Sun" ] ; then
		JAVA_HOME="${SUN_JAVA_HOME}"
		export JAVA_HOME
	else
JAVA_VENDOR="@JAVA_VENDOR"
		export JAVA_VENDOR
JAVA_HOME="@JAVA_HOME"
		export JAVA_HOME
		VM_TYPE="HotSpot"
		export VM_TYPE
	fi
fi

# We need to reset the value of JAVA_HOME to get it shortened AND 
# we can not shorten it above because immediate variable expansion will blank it

JAVA_HOME="${JAVA_HOME}"
export JAVA_HOME

SAMPLES_HOME="${WL_HOME}/samples"
export SAMPLES_HOME

DOMAIN_HOME="@DOMAIN_HOME"
export DOMAIN_HOME

LONG_DOMAIN_HOME="@DOMAIN_HOME"
export LONG_DOMAIN_HOME

if [ "${APPCDS_CLASS_LIST}" = "" ] ; then
	APPCDS_CLASS_LIST="${DOMAIN_HOME}/WebLogic.classlist"
	export APPCDS_CLASS_LIST
fi

if [ "${APPCDS_ARCHIVE}" = "" ] ; then
	APPCDS_ARCHIVE="${DOMAIN_HOME}/WebLogic.jsa"
	export APPCDS_ARCHIVE
fi

if [ "${DEBUG_PORT}" = "" ] ; then
	DEBUG_PORT="8453"
	export DEBUG_PORT
fi

if [ "${SERVER_NAME}" = "" ] ; then
SERVER_NAME="@SERVER_NAME"
	export SERVER_NAME
fi

# Set DERBY_FLAG, if derby is available.

if [ "${DERBY_FLAG}" = "" ] ; then
	if [ -f ${WL_HOME}/common/derby/lib/derby.jar ] ; then
		DERBY_FLAG="true"
		export DERBY_FLAG
	fi
fi

enableHotswapFlag=""
export enableHotswapFlag

PRODUCTION_MODE="@PRODUCTION_MODE"
export PRODUCTION_MODE

doExitFlag="false"
export doExitFlag
verboseLoggingFlag="false"
export verboseLoggingFlag
while [ $# -gt 0 ]
do
	case $1 in
	nodebug)
		debugFlag="false"
		export debugFlag
		;;
	production)
		DOMAIN_PRODUCTION_MODE="true"
		export DOMAIN_PRODUCTION_MODE
		;;
	noderby)
		DERBY_FLAG="false"
		export DERBY_FLAG
		;;
	doExit)
		doExitFlag="true"
		export doExitFlag
		;;
	noExit)
		doExitFlag="false"
		export doExitFlag
		;;
	verbose)
		verboseLoggingFlag="true"
		export verboseLoggingFlag
		;;
	enableHotswap)
		enableHotswapFlag="-javaagent:${WL_HOME}/server/lib/diagnostics-agent.jar"
		export enableHotswapFlag
		;;
	generateClassList)
		USE_JVM_SYSTEM_LOADER="true"
		export USE_JVM_SYSTEM_LOADER
		GENERATE_CLASS_LIST="true"
		export GENERATE_CLASS_LIST
		;;
	useArchive)
		USE_JVM_SYSTEM_LOADER="true"
		export USE_JVM_SYSTEM_LOADER
		USE_ARCHIVE="true"
		export USE_ARCHIVE
		;;
	*)
		PROXY_SETTINGS="${PROXY_SETTINGS} $1"
		export PROXY_SETTINGS
		;;
	esac
	shift
done


debugpatchAgent="-javaagent:${WL_HOME}/server/lib/debugpatch-agent.jar"
export debugpatchAgent

MEM_DEV_ARGS=""
export MEM_DEV_ARGS

if [ "${DOMAIN_PRODUCTION_MODE}" = "true" ] ; then
	PRODUCTION_MODE="${DOMAIN_PRODUCTION_MODE}"
	export PRODUCTION_MODE
fi

if [ "${PRODUCTION_MODE}" = "true" ] ; then
	debugFlag="false"
	export debugFlag
fi

# If you want to override the default Patch Classpath, Library Path and Path for this domain,
# Please uncomment the following lines and add a valid value for the environment variables
# set PATCH_CLASSPATH=[myPatchClasspath] (windows)
# set PATCH_LIBPATH=[myPatchLibpath] (windows)
# set PATCH_PATH=[myPatchPath] (windows)
# PATCH_CLASSPATH=[myPatchClasspath] (unix)
# PATCH_LIBPATH=[myPatchLibpath] (unix)
# PATCH_PATH=[myPatchPath] (unix)

. ${WL_HOME}/../oracle_common/common/bin/commEnv.sh

PATH="${DOMAIN_HOME}/bin${CLASSPATHSEP}${PATH}"
export PATH

WLS_HOME="${WL_HOME}/server"
export WLS_HOME

WLS_MEM_ARGS_64BIT="-Xms512m -Xmx512m"
export WLS_MEM_ARGS_64BIT

WLS_MEM_ARGS_32BIT="-Xms512m -Xmx512m"
export WLS_MEM_ARGS_32BIT

if [ "${JAVA_VENDOR}" != "HP" ] ; then
	if [ "${VM_TYPE}" = "HotSpot" ] ; then
		WLS_MEM_ARGS_64BIT="-Xms256m -Xmx512m"
		export WLS_MEM_ARGS_64BIT
		WLS_MEM_ARGS_32BIT="-Xms256m -Xmx512m"
		export WLS_MEM_ARGS_32BIT
	fi
fi

MEM_ARGS_64BIT="${WLS_MEM_ARGS_64BIT}"
export MEM_ARGS_64BIT

MEM_ARGS_32BIT="${WLS_MEM_ARGS_32BIT}"
export MEM_ARGS_32BIT

if [ "${JAVA_USE_64BIT}" = "true" ] ; then
	MEM_ARGS="${MEM_ARGS_64BIT}"
	export MEM_ARGS
else
	MEM_ARGS="${MEM_ARGS_32BIT}"
	export MEM_ARGS
fi

if [ "${JAVA_VENDOR}" != "HP" ] ; then
	if [ "${VM_TYPE}" = "HotSpot" ] ; then
		if [ "${PRODUCTION_MODE}" = "" ] ; then
			MEM_DEV_ARGS="-XX:CompileThreshold=8000"
			export MEM_DEV_ARGS
		fi
	fi
fi

# Had to have a separate test here BECAUSE of immediate variable expansion on windows

if [ "${JAVA_VENDOR}" != "HP" ] ; then
	if [ "${VM_TYPE}" = "HotSpot" ] ; then
		MEM_ARGS="${MEM_ARGS} ${MEM_DEV_ARGS}"
		export MEM_ARGS
	fi
fi

if [ "${JAVA_VENDOR}" = "HP" ] ; then
	MEM_ARGS="${MEM_ARGS}"
	export MEM_ARGS
fi

if [ "${JAVA_VENDOR}" = "Apple" ] ; then
	MEM_ARGS="${MEM_ARGS}"
	export MEM_ARGS
fi

# Set server startup configuration, if available.

if [ -f ${DOMAIN_HOME}/bin/setStartupEnv.sh ] ; then
	. ${DOMAIN_HOME}/bin/setStartupEnv.sh
fi

# Set user overrides, if available.

if [ -f ${DOMAIN_HOME}/bin/setUserOverrides.sh ] ; then
	. ${DOMAIN_HOME}/bin/setUserOverrides.sh
fi

# IF USER_MEM_ARGS the environment variable is set, use it to override ALL MEM_ARGS values

if [ "${USER_MEM_ARGS}" != "" ] ; then
	MEM_ARGS="${USER_MEM_ARGS}"
	export MEM_ARGS
fi

JAVA_PROPERTIES="-Dwls.home=${WLS_HOME} -Dweblogic.home=${WLS_HOME} "
export JAVA_PROPERTIES

#  To use Java Authorization Contract for Containers (JACC) in this domain, 
#  please uncomment the following section. If there are multiple machines in 
#  your domain, be sure to edit the setDomainEnv in the associated domain on 
#  each machine.
# 
# -Djava.security.manager
# -Djava.security.policy=location of weblogic.policy
# -Djavax.security.jacc.policy.provider=weblogic.security.jacc.simpleprovider.SimpleJACCPolicy
# -Djavax.security.jacc.PolicyConfigurationFactory.provider=weblogic.security.jacc.simpleprovider.PolicyConfigurationFactoryImpl
# -Dweblogic.security.jacc.RoleMapperFactory.provider=weblogic.security.jacc.simpleprovider.RoleMapperFactoryImpl

EXTRA_JAVA_PROPERTIES="-Djavax.management.builder.initial=weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder ${EXTRA_JAVA_PROPERTIES}"
export EXTRA_JAVA_PROPERTIES

JAVA_PROPERTIES="${JAVA_PROPERTIES} ${EXTRA_JAVA_PROPERTIES}"
export JAVA_PROPERTIES

pushd ${LONG_DOMAIN_HOME}

# Clustering support (edit for your cluster!)

if [ "${ADMIN_URL}" = "" ] ; then
	# The then part of this block is telling us we are either starting an admin server OR we are non-clustered
	CLUSTER_PROPERTIES=""
	export CLUSTER_PROPERTIES
else
	CLUSTER_PROPERTIES="-Dweblogic.management.server=${ADMIN_URL}"
	export CLUSTER_PROPERTIES
fi

if [ "${LOG4J_CONFIG_FILE}" != "" ] ; then
	JAVA_PROPERTIES="${JAVA_PROPERTIES} -Dlog4j.configuration=file:${LOG4J_CONFIG_FILE}"
	export JAVA_PROPERTIES
fi

JAVA_PROPERTIES="${JAVA_PROPERTIES} ${CLUSTER_PROPERTIES}"
export JAVA_PROPERTIES

JAVA_DEBUG=""
export JAVA_DEBUG

if [ "${debugFlag}" = "true" ] ; then
	JAVA_DEBUG="-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=${DEBUG_PORT},server=y,suspend=n -Djava.compiler=NONE"
	export JAVA_DEBUG
	JAVA_OPTIONS="${JAVA_OPTIONS} ${enableHotswapFlag} ${debugpatchAgent} -ea -da:com.bea... -da:javelin... -da:weblogic... -ea:com.bea.wli... -ea:com.bea.broker... -ea:com.bea.sbconsole..."
	export JAVA_OPTIONS
else
	JAVA_OPTIONS="${JAVA_OPTIONS} ${enableHotswapFlag} ${debugpatchAgent} -da"
	export JAVA_OPTIONS
fi

if [ ! -d ${JAVA_HOME}/lib ] ; then
	echo "The JRE was not found in directory ${JAVA_HOME}. (JAVA_HOME)"
	echo "Please edit your environment and set the JAVA_HOME"
	echo "variable to point to the root directory of your Java installation."
	popd
	read _val
	exit
fi

if [ "${DERBY_FLAG}" = "true" ] ; then
	DATABASE_CLASSPATH="${DERBY_CLASSPATH}"
	export DATABASE_CLASSPATH
else
	DATABASE_CLASSPATH="${DERBY_CLIENT_CLASSPATH}"
	export DATABASE_CLASSPATH
fi

if [ "${DATABASE_CLASSPATH}" != "" ] ; then
	if [ "${POST_CLASSPATH}" != "" ] ; then
		POST_CLASSPATH="${POST_CLASSPATH}${CLASSPATHSEP}${DATABASE_CLASSPATH}"
		export POST_CLASSPATH
	else
		POST_CLASSPATH="${DATABASE_CLASSPATH}"
		export POST_CLASSPATH
	fi
fi

# PROFILING SUPPORT

JAVA_PROFILE=""
export JAVA_PROFILE

SERVER_CLASS="weblogic.Server"
export SERVER_CLASS

JAVA_PROPERTIES="${JAVA_PROPERTIES} ${WLP_JAVA_PROPERTIES}"
export JAVA_PROPERTIES

JAVA_OPTIONS="${JAVA_OPTIONS} ${JAVA_PROPERTIES}"
export JAVA_OPTIONS

if [ "${PRODUCTION_MODE}" = "true" ] ; then
	JAVA_OPTIONS=" -Dweblogic.ProductionModeEnabled=true ${JAVA_OPTIONS}"
	export JAVA_OPTIONS
fi

# -- Setup properties so that we can save stdout and stderr to files

if [ "${WLS_STDOUT_LOG}" != "" ] ; then
	echo "Logging WLS stdout to ${WLS_STDOUT_LOG}"
	JAVA_OPTIONS="${JAVA_OPTIONS} -Dweblogic.Stdout=${WLS_STDOUT_LOG}"
	export JAVA_OPTIONS
fi

if [ "${WLS_STDERR_LOG}" != "" ] ; then
	echo "Logging WLS stderr to ${WLS_STDERR_LOG}"
	JAVA_OPTIONS="${JAVA_OPTIONS} -Dweblogic.Stderr=${WLS_STDERR_LOG}"
	export JAVA_OPTIONS
fi

# ADD EXTENSIONS TO CLASSPATHS

if [ "${EXT_PRE_CLASSPATH}" != "" ] ; then
	if [ "${PRE_CLASSPATH}" != "" ] ; then
		PRE_CLASSPATH="${EXT_PRE_CLASSPATH}${CLASSPATHSEP}${PRE_CLASSPATH}"
		export PRE_CLASSPATH
	else
		PRE_CLASSPATH="${EXT_PRE_CLASSPATH}"
		export PRE_CLASSPATH
	fi
fi

if [ "${EXT_POST_CLASSPATH}" != "" ] ; then
	if [ "${POST_CLASSPATH}" != "" ] ; then
		POST_CLASSPATH="${POST_CLASSPATH}${CLASSPATHSEP}${EXT_POST_CLASSPATH}"
		export POST_CLASSPATH
	else
		POST_CLASSPATH="${EXT_POST_CLASSPATH}"
		export POST_CLASSPATH
	fi
fi

if [ "${WEBLOGIC_EXTENSION_DIRS}" != "" ] ; then
	JAVA_OPTIONS="${JAVA_OPTIONS} -Dweblogic.ext.dirs=${WEBLOGIC_EXTENSION_DIRS}"
	export JAVA_OPTIONS
fi

JAVA_OPTIONS="${JAVA_OPTIONS}"
export JAVA_OPTIONS

# SET THE CLASSPATH

if [ "${WLP_POST_CLASSPATH}" != "" ] ; then
	if [ "${CLASSPATH}" != "" ] ; then
		CLASSPATH="${WLP_POST_CLASSPATH}${CLASSPATHSEP}${CLASSPATH}"
		export CLASSPATH
	else
		CLASSPATH="${WLP_POST_CLASSPATH}"
		export CLASSPATH
	fi
fi

if [ "${POST_CLASSPATH}" != "" ] ; then
	if [ "${CLASSPATH}" != "" ] ; then
		CLASSPATH="${POST_CLASSPATH}${CLASSPATHSEP}${CLASSPATH}"
		export CLASSPATH
	else
		CLASSPATH="${POST_CLASSPATH}"
		export CLASSPATH
	fi
fi

if [ "${WEBLOGIC_CLASSPATH}" != "" ] ; then
	if [ "${CLASSPATH}" != "" ] ; then
		CLASSPATH="${WEBLOGIC_CLASSPATH}${CLASSPATHSEP}${CLASSPATH}"
		export CLASSPATH
	else
		CLASSPATH="${WEBLOGIC_CLASSPATH}"
		export CLASSPATH
	fi
fi

if [ "${PRE_CLASSPATH}" != "" ] ; then
	CLASSPATH="${PRE_CLASSPATH}${CLASSPATHSEP}${CLASSPATH}"
	export CLASSPATH
fi

if [ "${VM_TYPE}" != "JRockit" ] ; then
	JAVA_VM="${JAVA_VM} ${JAVA_DEBUG} ${JAVA_PROFILE}"
	export JAVA_VM
else
	JAVA_VM="${JAVA_VM} ${JAVA_DEBUG} ${JAVA_PROFILE}"
	export JAVA_VM
fi

if [ "${WLS_POLICY_FILE}" = "" ] ; then
	WLS_POLICY_FILE="${WL_HOME}/server/lib/weblogic.policy"
	export WLS_POLICY_FILE
fi

