from java.util import *

edit()
startEdit()
cd("/")  

try:
  
  print 'server:' + serverName

  resName='ClusterManager'
  resMB=cmo.lookupWLDFSystemResource(resName)
  if resMB == None:
    print "Creating resource " + resName + " and targeting to " + serverName
    resMB=cmo.createWLDFSystemResource(resName)
    server=cmo.lookupServer(serverName)
    resMB.addTarget(server)
    
  res=resMB.getWLDFResource()
  wn=res.getWatchNotification()

  scaleUp=wn.lookupScaleUpAction('scaleUp')
  if scaleUp == None:
    print "Creating scale up action"
    scaleUp=wn.createScaleUpAction('scaleUp')
    scaleUp.setScalingFactor(1)
    scaleUp.setClusterName("dynamic1")

  scaleDown=wn.lookupScaleDownAction('scaleDown')
  if scaleDown == None:
    print "Creating scale down action"
    scaleDown=wn.createScaleDownAction('scaleDown')
    scaleDown.setScalingFactor(1)
    scaleDown.setClusterName("dynamic1")

  # Schedule the cluster to scale up 30 seconds from now
  cal=Calendar.getInstance()
  cal.add(Calendar.SECOND, 30)
  
  scaleUpDate=cal.getTime()
  print "Scheduling scale up at time " + scaleUpDate.toString() #str(scaleUpMinute)

  calendarUp=wn.lookupWatch('calendarScaleUpWatch')
  if calendarUp == None:
    print "Creating calendar-based scale-up watch"
    calendarUp=wn.createWatch('calendarScaleUpWatch')
  calendarUp.setExpressionLanguage('EL')
  calendarUp.getSchedule().setDayOfWeek(str(scaleUpDate.getDay()))
  calendarUp.getSchedule().setHour(str(scaleUpDate.getHours()))
  calendarUp.getSchedule().setMinute(str(scaleUpDate.getMinutes()))
  calendarUp.getSchedule().setSecond(str(scaleUpDate.getSeconds()))
  calendarUp.getRuleType()
  calendarUp.setAlarmType('ManualReset')
  calendarUp.setEnabled(true)
  calendarUp.addNotification(scaleUp)

  # Schedule the cluster to scale down 90 seconds later
  cal.add(Calendar.SECOND, 90)
  scaleDownDate=cal.getTime()
  print "Scheduling scale down at time " + scaleDownDate.toString() 

  calendarDown=wn.lookupWatch('calendarScaleDownWatch')
  if calendarDown == None:
    print "Creating calendar-based scale-down watch"
    calendarDown=wn.createWatch('calendarScaleDownWatch')
  calendarDown.setExpressionLanguage('EL')
  calendarDown.getSchedule().setDayOfWeek(str(scaleDownDate.getDay()))
  calendarDown.getSchedule().setHour(str(scaleDownDate.getHours()))
  calendarDown.getSchedule().setMinute(str(scaleDownDate.getMinutes()))
  calendarDown.getSchedule().setSecond(str(scaleDownDate.getSeconds()))
  calendarDown.getRuleType()
  calendarDown.setAlarmType('ManualReset')
  calendarDown.setEnabled(true)
  calendarDown.addNotification(scaleDown)

  high=wn.lookupWatch('highMark')
  if high != None:
    print "Disabling policy-based High Mark watch"
    high.setEnabled(false)
  
  low=wn.lookupWatch('lowMark')
  if low != None:
    print "Disabling policy-based Low Mark watch"
    low.setEnabled(false)
  
  print "Activating resource..."
  save()
  activate()
  print "Resource activated"
  
finally:
  if editService.getConfigurationManager().isEditor():
    cancelEdit('y')

print "Done"

