@ECHO OFF

@REM WARNING: This file is created by the Configuration Wizard.
@REM Any changes to this script may be lost when adding extensions to this configuration.

SETLOCAL

@REM --- Start Functions ---

GOTO :ENDFUNCTIONS

:usage
	echo Need to set APPCDS_CLASS_LIST and APPCDS_ARCHIVE environment variables or specify
	echo them in command line:
	echo Usage: %1 APPCDS_CLASS_LIST {APPCDS_ARCHIVE}
	echo for example:
	echo %1 %DOMAIN_HOME%\WebLogic.classlist %DOMAIN_HOME%\WebLogic.jsa 
GOTO :EOF


:ENDFUNCTIONS

@REM --- End Functions ---

@REM *************************************************************************
@REM This script is used to generate Java application-level Class Data Sharing (AppCDS) 
@REM archives, which are part of an optimized class loading strategy available
@REM with Oracle's JDK 8u40 and above.  Starting WebLogic using archives created with
@REM this script will result in improved server start-up time.  If multiple WebLogic
@REM managed servers are started on the same physical hardware, they may share the
@REM same AppCDS archive resulting in lowered memory utilization since the archives
@REM are accessed using shared memory.
@REM 
@REM AppCDS archives are created using a class path and a class list.
@REM 
@REM The class path will be taken from the value of the CLASSPATH environment variable
@REM 
@REM The class list can be generated in two ways:
@REM 1. Run WebLogic in class list trial mode
@REM    The classes loaded by WebLogic will be dumped when the server instance exits.
@REM    Use startWebLogic or startManagedWebLogic with the generateClassList option.
@REM 2. Generate default class list containing all classes on the CLASSPATH by
@REM    specifying "default" for the class list when generating the archive
@REM 
@REM Note: The class path used to generate the AppCDS archive must match the class path
@REM used when starting WebLogic.
@REM 
@REM *************************************************************************

set USE_JVM_SYSTEM_LOADER=true

@REM Call setDomainEnv here.

set DOMAIN_HOME=@DOMAIN_HOME
for %%i in ("%DOMAIN_HOME%") do set DOMAIN_HOME=%%~fsi

call "%DOMAIN_HOME%\bin\setDomainEnv.cmd" %*

if "%1"=="" (
	if "%APPCDS_CLASS_LIST%"=="" (
		CALL :usage %0
		GOTO :EOF
	)
) else (
	set APPCDS_CLASS_LIST=%1
	shift
)

if "%1"=="" (
	if "%APPCDS_ARCHIVE%"=="" (
		CALL :usage %0
		GOTO :EOF
	)
) else (
	set APPCDS_ARCHIVE=%1
	shift
)

%JAVA_HOME%\bin\java -XX:+UnlockCommercialFeatures -XX:+UnlockDiagnosticVMOptions -Xshare:dump -XX:+UseAppCDS -XX:+IgnoreEmptyClassPaths -XX:+TraceClassPaths -XX:+IgnoreUnverifiableClassesDuringDump -XX:SharedArchiveFile=%APPCDS_ARCHIVE% -XX:SharedClassListFile=%APPCDS_CLASS_LIST%



ENDLOCAL
