import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import java.util.logging.Level;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import commonj.work.WorkManager;

import weblogic.diagnostics.context.DiagnosticContextHelper;

import test.MyEJBClient;
import mytest.SimpleClient;
import mytest.SimplePortType;
import mytest.SimpleService_Impl;

/*
 * @author Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
 */

public class MySimpleServlet extends HttpServlet
{
    public void service(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException
    {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();

        out.println("<html>");
        out.println("<head><title>MySimpleServlet</title></head>");
        out.println("<body>");
        out.println("<P>Starting with ECID: " + DiagnosticContextHelper.getContextId() +
                    ", RID: " + DiagnosticContextHelper.getRID()+ "</P>");
        String ejbUrl = "t3://localhost:7004";
		
        // For demo, if there is a query string we will cause a failure
        performSomeWorkInAnotherThread(out, ejbUrl, (req.getQueryString() != null));
		callWS(out);
        out.println("</body></html>");
    }

    private long waitForDuration(long durationMillis) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + durationMillis;
        long remaining = durationMillis;
        long lastTime = startTime;
        while (remaining > 0) {
            try {
                Thread.sleep(remaining);
            } catch (InterruptedException ie) {}
            lastTime = System.currentTimeMillis();
            remaining = endTime - lastTime; // can be negative
        }
        return lastTime - startTime;
    }

    private void callWS(PrintWriter out) {
	  SimpleService_Impl service;
      try { 
        service = new SimpleService_Impl();
        SimplePortType port = service.getSimplePortTypeSoapPort(); // Defaults to http://localhost:7001/SimpleImpl/SimpleImpl
        String result = port.sayHello("Hi there! I'm ECID: " + DiagnosticContextHelper.getContextId() +
		    ", RID: " + DiagnosticContextHelper.getRID());
        out.println("<P>Web service called, returned " + result + "</P>");
      } catch (Throwable th) {
        Logger.getLogger("MyLogger").log(Level.WARNING, "MySimpleServlet.callWS reported failure", th);
        th.printStackTrace(new PrintWriter(out));
      }
	}

    private void performSomeWorkInAnotherThread(PrintWriter out, String ejbUrl, boolean shouldFail) {
      try {
        InitialContext ic = new InitialContext();
        WorkManager wm = (WorkManager)ic.lookup("java:comp/env/wm/WorkManager");
        Work myWork = new MyWork(out, ejbUrl, shouldFail);
        WorkItem workItem = wm.schedule(myWork);
        while ((workItem.getStatus() != WorkEvent.WORK_REJECTED) && (workItem.getStatus() != WorkEvent.WORK_COMPLETED)) { waitForDuration(1000); }
      } catch (Throwable th) {
        Logger.getLogger("MyLogger").log(Level.WARNING, "MySimpleServlet reported failure", th);
        th.printStackTrace(new PrintWriter(out));
      }
    }
	
    private static class MyWork implements Work {
      private volatile boolean keepRunning = false;
      private PrintWriter out = null;
	  private boolean shouldFail = false;
	  private String ejbUrl = null;

      public MyWork(PrintWriter out, String ejbUrl, boolean shouldFail) {
	    this.out = out;
        this.ejbUrl = ejbUrl;
        this.shouldFail = shouldFail;
      }

      public void release() { keepRunning = false; }
      public boolean isDaemon() { return false; }
	  
      public void run() {
        out.println("<P>Scheduled work is starting. ECID: " + DiagnosticContextHelper.getContextId() + " RID: " + DiagnosticContextHelper.getRID() + "</P>");
        callEJB();
      }

      private void callEJB() {
        try {
          MyEJBClient client = new MyEJBClient(ejbUrl);
          String myEJBClientInfo = "MyEJBClient ECID: " + DiagnosticContextHelper.getContextId() + " RID: " + DiagnosticContextHelper.getRID();
          String result = client.callMe(myEJBClientInfo, shouldFail);
          out.println("<P>EJB called, returned " + result + "</P>");
        } catch (Throwable th) {
          Logger.getLogger("MyLogger").log(Level.WARNING, "MySimpleServlet.callEJB reported failure", th);
		  out.println("<P>EJB call FAILED: " + th + "</P>");
        }
      }
    }

}
