package test;

import java.rmi.RemoteException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import weblogic.diagnostics.context.DiagnosticContextHelper;

/*
 * @author Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
 */
 
public class MyEJBClient
{
  private static String JNDI_NAME = "MyEJBHome";
  private String url;
  private MyEJBHome home;

  public MyEJBClient(String url) throws NamingException {
    this.url = url;
    home = lookupHome();
  }

  /**
   * Runs  from the command line. Example:
   * <p>
   * <tt>java statelessSession.Client "t3://localhost:7001"</tt>
   * <p>
   * The parameters are optional, but if any are supplied,
   * they are interpreted in this order:
   * <p>
   * @param args               URL such as "t3://localhost:7001" of Server
   */
  public static void main(String[] args) throws Exception {
    log("\nBeginning MyEJBClient...\n");
    String url  = "t3://localhost:7001";
	boolean shouldFail = false;

    MyEJBClient client = null;

    // Parse the argument list
    if (args.length < 1) {
      log("Usage: java MyEJBClient t3://host1:port1 [shouldFail-boolean]");
      return;
    } else {
      url = args[0];
	  if (args.length > 1)
        shouldFail = Boolean.parseBoolean(args[1]);
    }

    try {
      // Call MyEJB supplying the URLs which were provided, these may be null if 
      client = new MyEJBClient(url);
      String MyEJBClientInfo = "MyEJBClient ECID: " + DiagnosticContextHelper.getContextId() + " RID: " + getRID();
      String result = client.callMe(MyEJBClientInfo, shouldFail);
      log("Test url1: " + url + ", shouldFail: " + shouldFail + " returned:\n" + result);
    } catch (NamingException ne) {
      log("Unable to look up the beans home: " + ne.getMessage());
      throw ne;
    } catch (Exception e) {
      log("There was an exception while creating and using the MyEJB.");
      log("This indicates that there was a problem communicating with the server: "+e);
      throw e;
    }

    log("\nEnd MyEJBClient...\n");
  }

  /**
   * RMI/IIOP clients should use this narrow function
   */
  private Object narrow(Object ref, Class c) {
    return PortableRemoteObject.narrow(ref, c);
  }

  /**
   * Lookup the EJBs home in the JNDI tree
   */
  private MyEJBHome lookupHome() throws NamingException {
    // Lookup the beans home using JNDI
    Context ctx = getInitialContext();
    try {
      Object home = ctx.lookup(JNDI_NAME);
      return (MyEJBHome) narrow(home, MyEJBHome.class);
    } catch (NamingException ne) {
      log("The client was unable to lookup the EJBHome.  Please make sure ");
      log("that you have deployed the ejb with the JNDI name "+
        JNDI_NAME+" on the WebLogic server at "+url);
      throw ne;
    }
  }

  /**
   * Using a Properties object will work on JDK 1.1.x and Java2
   * clients
   */
  private Context getInitialContext() throws NamingException {
    
    try {
      // Get an InitialContext
      Hashtable<String,String> h = new Hashtable<String,String>();
      h.put(Context.INITIAL_CONTEXT_FACTORY,
        "weblogic.jndi.WLInitialContextFactory");
      h.put(Context.PROVIDER_URL, url);
      return new InitialContext(h);
    } catch (NamingException ne) {
      log("We were unable to get a connection to the WebLogic server at "+url);
      log("Please make sure that the server is running.");
      throw ne;
    }
  }

  public String callMe(String input, boolean shouldFail)
    throws CreateException, RemoteException, RemoveException, Exception
  {
    log("Creating a MyEJB");
    MyEJB MyEJB = (MyEJB) narrow(home.create(), MyEJB.class);
    String clientInfo = "\n  MyEJBClient ECID: " + DiagnosticContextHelper.getContextId() + " RID: " + getRID();
    log("MyEJBClient.callMe clientInfo: " + clientInfo);
    String returnInfo = MyEJB.callMe(clientInfo, shouldFail);
    log("MyEJBClient.callMe returnInfo: " + returnInfo);
    log("Removing the MyEJB");
    MyEJB.remove();
    return returnInfo;
  }

  private static String getRID() {
    try {
      Method getRIDMtd = DiagnosticContextHelper.class.getDeclaredMethod("getRID", (Class <?> [])null);
      return (String ) getRIDMtd.invoke(null, (Object [])null);
    } catch (Throwable th) {}
    return "No RID";
  }

  private static void log(String s) { System.out.println(s); }
 
}
