package vpd;

import java.io.IOException;
import java.io.PrintWriter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.*;

import javax.sql.DataSource;

@WebServlet(name = "show", urlPatterns = { "/show" })
public class show extends HttpServlet {
    private static final String CONTENT_TYPE = "text/html; charset=windows-31j";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>show</title></head>");
        out.println("<body>");

        out.println("<div align=\"right\">Welcome, " + request.getRemoteUser() + "<br>");
        out.println("<a href=\"/dbsecnavi\">home</a> <a href=\"/dbsecnavi/vpd/logout\">logout</a></div>");
        
        Connection conn = null;
        
        try {
            Context context = new InitialContext();
            DataSource ds = (DataSource)context.lookup("jdbc/dbsecnavi");

            conn = ds.getConnection();

            Statement stmt = conn.createStatement();

            ResultSet rset = stmt.executeQuery("select sys_context('userenv','session_user'), sys_context('userenv','client_identifier'), sys_context('userenv','client_program_name') from dual");
            rset.next();
            out.println("Database User: " + rset.getString(1) + "<br>Application User: " + rset.getString(2) + "<br>Application Name: " + rset.getString(3) + "<br>");

            rset = stmt.executeQuery("select name from app1.testtab");
            
            out.println("<table border=1><tr><th>NAME</th></tr>");
            
            while(rset.next()){
                out.println("</td><td>" + rset.getString("name") + "</td></tr>");
            }
            
            out.println("</table>");

            rset.close();
            stmt.close();
        
            conn.close();
        
        } catch (Exception e) {
            out.println(e.toString());
            try{
                conn.close();
            }catch (Exception e2){
                out.println(e.toString());
            }
        }

        out.println("</body></html>");
        out.close();
    }
}
