CONNECT / AS SYSDBA

CREATE TABLESPACE med_archive_1
DATAFILE '/u01/app/oracle/oradata/orcl/med_archive_1_1.dbf'
SIZE 4M SEGMENT SPACE MANAGEMENT AUTO;

CREATE TABLESPACE med_archive_2
DATAFILE '/u01/app/oracle/oradata/orcl/med_archive_2_1.dbf'
SIZE 4M SEGMENT SPACE MANAGEMENT AUTO;

CREATE USER med_test IDENTIFIED BY secret
DEFAULT TABLESPACE users
QUOTA UNLIMITED ON users
QUOTA UNLIMITED ON med_archive_1
QUOTA UNLIMITED ON med_archive_2;

GRANT CONNECT, RESOURCE TO med_test;

CONNECT med_test/secret

CREATE TABLE test_name (
test_code VARCHAR2(4),
test_name VARCHAR2(30),
CONSTRAINT test_name_pk
PRIMARY KEY (test_code)
);

CREATE TABLE test_result (
patient_id NUMBER,
test_time TIMESTAMP,
test_code VARCHAR2(4),
test_result VARCHAR2(10),
CONSTRAINT test_result_pk
PRIMARY KEY (patient_id, test_time, test_code),
CONSTRAINT test_code_fk
FOREIGN KEY (test_code)
REFERENCES test_name
);

--Insert some specific items to test for
INSERT INTO test_name VALUES ('coca','Cocaine');
INSERT INTO test_name VALUES ('mari','Marijuana');
INSERT INTO test_name VALUES ('ampa','Amphetamines');
INSERT INTO test_name VALUES ('phen','Phencyclidine');

--Insert some results for a few patients
INSERT INTO test_result VALUES (101, TIMESTAMP '2007-02-01 13:17:00', 'coca', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2007-02-01 13:17:00', 'mari', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2007-02-01 13:17:00', 'ampa', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2007-02-01 13:17:00', 'phen', 'Negative');

INSERT INTO test_result VALUES (101, TIMESTAMP '2008-02-01 13:17:00', 'coca', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2008-02-01 13:17:00', 'mari', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2008-02-01 13:17:00', 'ampa', 'Negative');
INSERT INTO test_result VALUES (101, TIMESTAMP '2008-02-01 13:17:00', 'phen', 'Negative');

INSERT INTO test_result VALUES (102, TIMESTAMP '2008-02-01 15:32:00', 'coca', 'Negative');
INSERT INTO test_result VALUES (102, TIMESTAMP '2008-02-01 15:32:00', 'mari', 'Positive');
INSERT INTO test_result VALUES (102, TIMESTAMP '2008-02-01 15:32:00', 'ampa', 'Negative');
INSERT INTO test_result VALUES (102, TIMESTAMP '2008-02-01 15:32:00', 'phen', 'Negative');

INSERT INTO test_result VALUES (103, TIMESTAMP '2008-02-02 09:54:00', 'coca', 'Positive');
INSERT INTO test_result VALUES (103, TIMESTAMP '2008-02-02 09:54:00', 'mari', 'Negative');
INSERT INTO test_result VALUES (103, TIMESTAMP '2008-02-02 09:54:00', 'ampa', 'Positive');
INSERT INTO test_result VALUES (103, TIMESTAMP '2008-02-02 09:54:00', 'phen', 'Negative');

INSERT INTO test_result VALUES (104, TIMESTAMP '2008-02-03 12:32:00', 'coca', 'Negative');
INSERT INTO test_result VALUES (104, TIMESTAMP '2008-02-03 12:32:00', 'mari', 'Negative');
INSERT INTO test_result VALUES (104, TIMESTAMP '2008-02-03 12:32:00', 'ampa', 'Negative');
INSERT INTO test_result VALUES (104, TIMESTAMP '2008-02-03 12:32:00', 'phen', 'Positive');

COMMIT;

