-- create a simple table to use during fetch test
create table fetch_test
(
  id   number primary key,
  data varchar2(32)
);

-- anonymous pl/sql block to populate the table
begin
  for i in 1..100000 loop
    insert into fetch_test
    values (i, to_char(i, '000000'));
  end loop;
end;
/

-- commit the insert
commit;

-- create statistics on the table
begin
  dbms_stats.gather_table_stats(
    ownname => 'HR',
    tabname => 'FETCH_TEST',
    estimate_percent => null,
    method_opt => 'for all indexed columns size 1',
    cascade => TRUE);
end;
/
