rem Copyright (c) 2001, 2015, Oracle and/or its affiliates.  All rights reserved. 
rem 
rem Permission is hereby granted, free of charge, to any person obtaining
rem a copy of this software and associated documentation files (the
rem "Software"), to deal in the Software without restriction, including
rem without limitation the rights to use, copy, modify, merge, publish,
rem distribute, sublicense, and/or sell copies of the Software, and to
rem permit persons to whom the Software is furnished to do so, subject to
rem the following conditions:
rem 
rem The above copyright notice and this permission notice shall be
rem included in all copies or substantial portions of the Software.
rem 
rem THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
rem EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
rem MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
rem NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
rem LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
rem OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
rem WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
rem
rem
------------------------------------------

REM ********************************************************************
REM Create the REGIONS table to hold region information for locations
REM COUNTRIES table has a foreign key to this table.


CREATE TABLE regions
    ( region_id      NUMBER 
       CONSTRAINT  region_id_nn NOT NULL 
    , region_name    VARCHAR2(25) 
    );

CREATE UNIQUE INDEX reg_id_pk
ON regions (region_id);

ALTER TABLE regions
ADD ( CONSTRAINT reg_id_pk
       		 PRIMARY KEY (region_id)
    ) ;

REM ********************************************************************
REM Create the COUNTRIES table to hold country information for customers
REM and company locations. 
REM LOCATIONS table has a foreign key to this table.

CREATE TABLE countries 
    ( country_id      NUMBER
          CONSTRAINT country_id_nn NOT NULL 
    , country_code    VARCHAR2(2) NOT NULL
    , country_name    VARCHAR2(40) 
    , region_id       NUMBER NOT NULL
    , CONSTRAINT     country_c_id_pk 
        	     PRIMARY KEY (country_id) 
    , constraint     country_c_code_pk
                UNIQUE( country_code )
    ); 

ALTER TABLE countries
ADD ( CONSTRAINT countr_reg_fk
        	 FOREIGN KEY (region_id)
          	  REFERENCES regions(region_id) 
    ) ;



create sequence countries_seq;

create or replace trigger countries_trg1
before insert or update on countries
for each row
begin
    if inserting then
        select countries_seq.nextval into :new.country_id from dual;
    end if;
    :new.country_code := upper(:new.country_code);
end;
/


REM ********************************************************************
REM Create the LOCATIONS table to hold address information for company departments.
REM HR.DEPARTMENTS has a foreign key to this table.

CREATE TABLE locations
    ( location_id    NUMBER(4)
    , street_address VARCHAR2(40)
    , postal_code    VARCHAR2(12)
    , city       VARCHAR2(30)
	CONSTRAINT     loc_city_nn  NOT NULL
    , state_province VARCHAR2(25)
    , country_code     VARCHAR(2) NOT NULL
    ) ;


ALTER TABLE locations
ADD ( CONSTRAINT loc_id_pk
       		 PRIMARY KEY (location_id)
    , CONSTRAINT loc_c_id_fk
       		 FOREIGN KEY (country_code)
        	  REFERENCES countries(country_code) 
    ) ;

Rem 	Useful for any subsequent addition of rows to locations table
Rem 	Starts with 3300

CREATE SEQUENCE locations_seq
 START WITH     3300
 INCREMENT BY   100
 MAXVALUE       9900
 NOCACHE
 NOCYCLE;


REM ***************************insert data into the REGIONS table


INSERT INTO regions VALUES 
        ( 1
        , 'Europe' 
        );

INSERT INTO regions VALUES 
        ( 2
        , 'Americas' 
        );

INSERT INTO regions VALUES 
        ( 3
        , 'Asia' 
        );

INSERT INTO regions VALUES 
        ( 4
        , 'Middle East and Africa' 
        );

REM ***************************insert data into the COUNTRIES table


INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'IT'
        , 'Italy'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'JP'
        , 'Japan'
	, 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'US'
        , 'United States of America'
        , 2 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'CA'
        , 'Canada'
        , 2 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'CN'
        , 'China'
        , 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'IN'
        , 'India'
        , 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'AU'
        , 'Australia'
        , 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'ZW'
        , 'Zimbabwe'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'SG'
        , 'Singapore'
        , 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'UK'
        , 'United Kingdom'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'FR'
        , 'France'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'DE'
        , 'Germany'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'ZM'
        , 'Zambia'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'EG'
        , 'Egypt'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'BR'
        , 'Brazil'
        , 2 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'CH'
        , 'Switzerland'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'NL'
        , 'Netherlands'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'MX'
        , 'Mexico'
        , 2 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'KW'
        , 'Kuwait'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'IL'
        , 'Israel'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'DK'
        , 'Denmark'
        , 1 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'ML'
        , 'Malaysia'
        , 3 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'NG'
        , 'Nigeria'
        , 4 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'AR'
        , 'Argentina'
        , 2 
        );

INSERT INTO countries( country_code, country_name, region_id) VALUES 
        ( 'BE'
        , 'Belgium'
        , 1 
        );


REM ***************************insert data into the LOCATIONS table


INSERT INTO locations VALUES 
        ( 1000 
        , '1297 Via Cola di Rie'
        , '00989'
        , 'Roma'
        , NULL
        , 'IT'
        );

INSERT INTO locations VALUES 
        ( 1100 
        , '93091 Calle della Testa'
        , '10934'
        , 'Venice'
        , NULL
        , 'IT'
        );

INSERT INTO locations VALUES 
        ( 1200 
        , '2017 Shinjuku-ku'
        , '1689'
        , 'Tokyo'
        , 'Tokyo Prefecture'
        , 'JP'
        );

INSERT INTO locations VALUES 
        ( 1300 
        , '9450 Kamiya-cho'
        , '6823'
        , 'Hiroshima'
        , NULL
        , 'JP'
        );

INSERT INTO locations VALUES 
        ( 1400 
        , '2014 Jabberwocky Rd'
        , '26192'
        , 'Southlake'
        , 'Texas'
        , 'US'
        );

INSERT INTO locations VALUES 
        ( 1500 
        , '2011 Interiors Blvd'
        , '99236'
        , 'South San Francisco'
        , 'California'
        , 'US'
        );

INSERT INTO locations VALUES 
        ( 1600 
        , '2007 Zagora St'
        , '50090'
        , 'South Brunswick'
        , 'New Jersey'
        , 'US'
        );

INSERT INTO locations VALUES 
        ( 1700 
        , '2004 Charade Rd'
        , '98199'
        , 'Seattle'
        , 'Washington'
        , 'US'
        );

INSERT INTO locations VALUES 
        ( 1800 
        , '147 Spadina Ave'
        , 'M5V 2L7'
        , 'Toronto'
        , 'Ontario'
        , 'CA'
        );

INSERT INTO locations VALUES 
        ( 1900 
        , '6092 Boxwood St'
        , 'YSW 9T2'
        , 'Whitehorse'
        , 'Yukon'
        , 'CA'
        );

INSERT INTO locations VALUES 
        ( 2000 
        , '40-5-12 Laogianggen'
        , '190518'
        , 'Beijing'
        , NULL
        , 'CN'
        );

INSERT INTO locations VALUES 
        ( 2100 
        , '1298 Vileparle (E)'
        , '490231'
        , 'Bombay'
        , 'Maharashtra'
        , 'IN'
        );

INSERT INTO locations VALUES 
        ( 2200 
        , '12-98 Victoria Street'
        , '2901'
        , 'Sydney'
        , 'New South Wales'
        , 'AU'
        );

INSERT INTO locations VALUES 
        ( 2300 
        , '198 Clementi North'
        , '540198'
        , 'Singapore'
        , NULL
        , 'SG'
        );

INSERT INTO locations VALUES 
        ( 2400 
        , '8204 Arthur St'
        , NULL
        , 'London'
        , NULL
        , 'UK'
        );

INSERT INTO locations VALUES 
        ( 2500 
        , 'Magdalen Centre, The Oxford Science Park'
        , 'OX9 9ZB'
        , 'Oxford'
        , 'Oxford'
        , 'UK'
        );

INSERT INTO locations VALUES 
        ( 2600 
        , '9702 Chester Road'
        , '09629850293'
        , 'Stretford'
        , 'Manchester'
        , 'UK'
        );

INSERT INTO locations VALUES 
        ( 2700 
        , 'Schwanthalerstr. 7031'
        , '80925'
        , 'Munich'
        , 'Bavaria'
        , 'DE'
        );

INSERT INTO locations VALUES 
        ( 2800 
        , 'Rua Frei Caneca 1360 '
        , '01307-002'
        , 'Sao Paulo'
        , 'Sao Paulo'
        , 'BR'
        );

INSERT INTO locations VALUES 
        ( 2900 
        , '20 Rue des Corps-Saints'
        , '1730'
        , 'Geneva'
        , 'Geneve'
        , 'CH'
        );

INSERT INTO locations VALUES 
        ( 3000 
        , 'Murtenstrasse 921'
        , '3095'
        , 'Bern'
        , 'BE'
        , 'CH'
        );

INSERT INTO locations VALUES 
        ( 3100 
        , 'Pieter Breughelstraat 837'
        , '3029SK'
        , 'Utrecht'
        , 'Utrecht'
        , 'NL'
        );

INSERT INTO locations VALUES 
        ( 3200 
        , 'Mariano Escobedo 9991'
        , '11932'
        , 'Mexico City'
        , 'Distrito Federal,'
        , 'MX'
        );
