REM <<script starts here>>
spool C:\miscellaneous\sql_101\Install_10\sql_101_examples_script.lst

REM 3) Drop the user, SQL_101. This will delete the user, SQL_101, and delete any of its schema objects.

drop user sql_101 cascade;

REM 4) Create the user, SQL_101.

create user sql_101 identified by Ashton0719
default tablespace users
temporary tablespace temp
quota unlimited on users;

REM If you are using a pre-existing database to run this article series'' examples, please ask your database administrator for the name of both the default and temporary
REM tablespace to supply in the above SQL statement. In this instance, you should also ask the administrator for an appropriate value to supply for the quota on the default
REM tablespace.

REM Be sure to include the ending semicolon in each SQL statement in this script. SQL*Plus uses the semicolon character as a SQL statement terminator to know when to send the
REM statement to the database for execution.

REM 5) Grant privileges to the SQL_101 user to create a database session (to be able to run SQL statements) and to create objects in your SQL_101 database schema.

grant connect, resource to sql_101;

REM 6) Connect as the user, SQL_101.

connect sql_101
REM When prompted for the password (Example: Enter password: ) enter_the_password_you_supplied_above.
REM If you have supplied the correct password, you will receive a confirmation that reads:  Connected.

REM 7) Create the objects you will use. (This script will be altered and exanded upon as necessary with each installation of this article series.)

CREATE TABLE employee (
employee_id   NUMBER,
first_name    VARCHAR2(30),
last_name     VARCHAR2(30),
hire_date     DATE,
salary        NUMBER(9,2),
manager       NUMBER,
department_id NUMBER
);

CREATE TABLE department (
department_id NUMBER,
name          VARCHAR2(30),
location      VARCHAR2(30)
);

CREATE SEQUENCE employee_seq; 

CREATE SEQUENCE department_seq;

REM These sequences will be used eventually. For now, in order for your output to match that shown in the series articles'' examples,
REM please insert literal number values into the ID columns of the tables as shown below.

REM 8) Insert records into the employee table.

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (28, 'Emily', 'Eckhardt', to_date('07-JUL-2004', 'DD-MON-YYYY'), 100000, NULL, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (37, 'Frances', 'Newton', to_date('14-SEP-2005', 'DD-MON-YYYY'), 75000, NULL, NULL);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (1234, 'Donald', 'Newton', to_date('24-SEP-2006', 'DD-MON-YYYY'), 80000, 28, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (7895, 'Matthew', 'Michaels', to_date('16-MAY-2007', 'DD-MON-YYYY'), 70000, 28, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6567, 'Roger', 'Friedli', to_date('16-MAY-2007', 'DD-MON-YYYY'), 60000, 28, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6568, 'Betsy', 'James', to_date('16-MAY-2007', 'DD-MON-YYYY'), 60000, 28, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6569, 'michael', 'peterson', to_date('03-NOV-2008', 'DD-MON-YYYY'), 90000, NULL, 20);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6570, 'mark', 'leblanc', to_date('06-MAR-2009', 'DD-MON-YYYY'), 65000, 6569, 20);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6571, 'Thomas', 'Jeffrey', to_date('27-FEB-2010', 'DD-MON-YYYY'), 300000, null, 30);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6572, 'Theresa', 'Wong', to_date('27-FEB-2010 9:02:45', 'DD-MON-YYYY HH24:MI:SS'), 70000, 6571, 30);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (6573, 'Lori', 'Dovichi', to_date('07-JUL-2011 8:31:57', 'DD-MON-YYYY HH24:MI:SS'), null, 28, 10);

REM 9) Insert records into the department table.


INSERT INTO department (department_id, name, location)
                VALUES (10, 'Accounting', 'LOS ANGELES');

INSERT INTO department (department_id, name, location)
                VALUES (20, 'Payroll', 'NEW YORK');

INSERT INTO department (department_id, name, location)
                VALUES (30, 'IT', 'WASHINGTON DC');

REM 10) Save your newly created records to the database.

Commit;

spool off