REM NOTE:  Be aware that the Oracle-defined user SCOTT already has tables named EMP and DEPT. Do not use these tables for the examples in this article series.
REM Please use the REM tables provided in this script. These tables and objects will be expanded upon as the article series continues.
REM All concepts and constructs in this script will be explained in the article series examples.

REM IMPORTANT:  Every statement must be run. Each statement below begins with a keyword like CREATE, INSERT or COMMIT, and ends with a semicolon character.
REM This script's examples use SQL*Plus. However, you may use the editor of your choice. Run each statement individually, or run all statements as a script.
REM If you choose to run these statements as a script, save this script into a directory on the server where your database is installed. Be sure to give this script a .sql
REM extension.  For example:  sql_101_examples_script.sql
REM Before you can run the script, you need to log into the database.

REM 1) Navigate to the directory where you have saved the below script.

REM 2) Log on to SQL*Plus as SYS and connect using the AS SYSDBA privilege.

sqlplus connect sys as sysdba
Enter password: <the password for the user, SYS>

REM <<script starts here>>
spool <a directory of your choosing>/sql_101_examples_script.lst

REM 3) Drop the user, SQL_101. This will delete the user, SQL_101, and delete any of its schema objects.

drop user sql_101 cascade;

REM 4) Create the user, SQL_101.

create user sql_101 identified by <supply_a_password_and_make_a_note_of_it>
default tablespace users
temporary tablespace temp
quota unlimited on users;

REM If you are using a pre-existing database to run this article series'' examples, please ask your database administrator for the name of both the default and temporary
REM tablespace to supply in the above SQL statement. In this instance, you should also ask the administrator for an appropriate value to supply for the quota on the default
REM tablespace.

REM Be sure to include the ending semicolon in each SQL statement in this script. SQL*Plus uses the semicolon character as a SQL statement terminator to know when to send the
REM statement to the database for execution.

REM 5) Grant privileges to the SQL_101 user to create a database session (to be able to run SQL statements) and to create objects in your SQL_101 database schema.

grant connect, resource to sql_101;

REM 6) Connect as the user, SQL_101.

connect sql_101
REM When prompted for the password (Example: Enter password: ) enter_the_password_you_supplied_above.
REM If you have supplied the correct password, you will receive a confirmation that reads:  Connected.

REM 7) Create the objects you will use. (This script will be altered and exanded upon as necessary with each installation of this article series.)

CREATE TABLE employee (
employee_id   NUMBER,
first_name    VARCHAR2(30),
last_name     VARCHAR2(30),
hire_date     DATE,
salary        NUMBER(9,2),
manager       NUMBER,
department_id NUMBER
);

CREATE TABLE department (
department_id NUMBER,
name          VARCHAR2(30)
);

CREATE SEQUENCE employee_seq; 

CREATE SEQUENCE department_seq;

REM These sequences will be used eventually. For now, in order for your output to match that shown in the series articles'' examples,
REM please insert literal number values into the ID columns of the tables as shown below.

REM 8) Insert records into the employee table.

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (28, 'Emily', 'Eckhardt', to_date('07-JUL-2004', 'DD-MON-YYYY'), 100000, NULL, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (37, 'Frances', 'Newton', to_date('14-SEP-2005', 'DD-MON-YYYY'), 75000, NULL, NULL);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (1234, 'Donald', 'Newton', to_date('24-SEP-2006', 'DD-MON-YYYY'), 80000, 28, 10);

INSERT INTO employee (employee_id, first_name, last_name, hire_date, salary, manager, department_id)
              VALUES (7895, 'Matthew', 'Michaels', to_date('16-MAY-2007', 'DD-MON-YYYY'), 70000, 28, 10);

REM 9) Insert records into the department table.


INSERT INTO department (department_id, name)
                VALUES (10, 'Accounting');

INSERT INTO department (department_id, name)
                VALUES (20, 'Payroll');

REM 10) Save your newly created records to the database.

Commit;

spool off

REM <<script ends here>>

REM At the SQL*Plus command prompt, SQL>, run this script by typing @<your script_name>.  For example:  SQL>@sql_101_examples_script.sql

REM Check to ensure your work was successful by navigating to the directory listed just above Step 3) (above).  The results of your work should be saved, or spooled, to
REM sql_101_examples_script.lst
REM If your script ran successfully, your results should resemble the following.

REM NOTE:  The very first time you run this script, there will be no user to drop. Therefore you will receive the message  
REM  ERROR at line 1:
REM  ORA-01918: user 'SQL_101' does not exist
REM This is to be expected.

REM <<results begin here>>

User dropped.

User created.


Grant succeeded.

Connected.

Table created.


Table created.


Sequence created.


Sequence created.


1 row created.


1 row created.


1 row created.


1 row created.


1 row created.


1 row created.


Commit complete.

REM <<results end here>>